/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.websocket.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.noear.solon.Utils;
import org.noear.solon.server.ServerLifecycle;
import org.noear.solon.server.prop.ServerSslProps;
import org.noear.solon.server.prop.impl.WebSocketServerProps;
import org.noear.solon.server.ssl.SslContextFactory;
import org.noear.solon.server.websocket.netty.NettyWsServerHandler;

public class NettyWsServer
implements ServerLifecycle {
    private ChannelFuture _server;
    private final WebSocketServerProps _props;
    private ServerSslProps sslProps;
    private SSLContext sslContext;

    protected boolean supportSsl() {
        if (this.sslProps == null) {
            this.sslProps = ServerSslProps.of((String)"websocket");
        }
        return this.sslProps.isEnable() && this.sslProps.getSslKeyStore() != null;
    }

    public NettyWsServer(WebSocketServerProps props) {
        this._props = props;
    }

    public void start(String host, int port) throws Throwable {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(this._props.getCoreThreads());
        NioEventLoopGroup workGroup = new NioEventLoopGroup(this._props.getMaxThreads(false));
        try {
            if (this.supportSsl()) {
                this.sslContext = SslContextFactory.create((ServerSslProps)this.sslProps);
            }
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    if (NettyWsServer.this.sslContext != null) {
                        SSLEngine engine = NettyWsServer.this.sslContext.createSSLEngine();
                        engine.setUseClientMode(false);
                        engine.setNeedClientAuth(true);
                        pipeline.addFirst(new ChannelHandler[]{new SslHandler(engine)});
                    }
                    pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                    pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    pipeline.addLast(new ChannelHandler[]{new NettyWsServerHandler(NettyWsServer.this._props)});
                }
            });
            this._server = Utils.isEmpty((String)host) ? bootstrap.bind(port).await() : bootstrap.bind(host, port).await();
        }
        catch (RuntimeException e) {
            bossGroup.shutdownGracefully();
            workGroup.shutdownGracefully();
            throw e;
        }
        catch (Throwable e) {
            bossGroup.shutdownGracefully();
            workGroup.shutdownGracefully();
            throw new IllegalStateException(e);
        }
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.channel().close();
        this._server = null;
    }
}

