/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.vertx.http;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import java.io.IOException;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.vertx.integration.VxHttpPlugin;
import org.noear.solon.server.vertx.websocket.VxWebSocketHandlerImpl;
import org.noear.solon.web.vertx.VxWebHandler;

public class VxWebHandlerPlus
extends VxWebHandler {
    private boolean enableWebSocket;
    private VxWebSocketHandlerImpl vxWebSocketHandlerImpl = new VxWebSocketHandlerImpl();

    public void enableWebSocket(boolean enable) {
        this.enableWebSocket = enable;
    }

    protected void preHandle(Context ctx) throws IOException {
        if (ServerProps.output_meta) {
            ctx.headerSet("Solon-Server", VxHttpPlugin.solon_server_ver());
        }
    }

    public void handle(HttpServerRequest req) {
        String upgradeStr;
        if (this.enableWebSocket && Utils.isNotEmpty((String)(upgradeStr = req.getHeader("Upgrade"))) && upgradeStr.contains("websocket")) {
            this.vxWebSocketHandlerImpl.subProtocolCapable(req);
            req.toWebSocket().onSuccess(ws -> this.vxWebSocketHandlerImpl.handle((ServerWebSocket)ws));
            return;
        }
        super.handle(req);
    }
}

