/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.undertow.websocket;

import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.noear.solon.net.websocket.WebSocketBase;
import org.noear.solon.server.undertow.websocket.CallbackFuture;
import org.noear.solon.server.util.DecodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketImpl
extends WebSocketBase {
    private static final Logger log = LoggerFactory.getLogger(WebSocketImpl.class);
    private WebSocketChannel real;

    public WebSocketImpl(WebSocketChannel real) {
        this.real = real;
        String uri = DecodeUtils.rinseUri((String)real.getUrl());
        this.init(URI.create(uri));
    }

    public boolean isValid() {
        return !this.isClosed() && this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.isSecure();
    }

    public InetSocketAddress remoteAddress() {
        return this.real.getSourceAddress();
    }

    public InetSocketAddress localAddress() {
        return this.real.getDestinationAddress();
    }

    public long getIdleTimeout() {
        return this.real.getIdleTimeout();
    }

    public void setIdleTimeout(long idleTimeout) {
        this.real.setIdleTimeout(idleTimeout);
    }

    public Future<Void> send(String text) {
        CallbackFuture future = new CallbackFuture();
        WebSockets.sendText((String)text, (WebSocketChannel)this.real, (WebSocketCallback)future);
        return future;
    }

    public Future<Void> send(ByteBuffer binary) {
        CallbackFuture future = new CallbackFuture();
        WebSockets.sendBinary((ByteBuffer)binary, (WebSocketChannel)this.real, (WebSocketCallback)future);
        return future;
    }

    public void close() {
        block3: {
            super.close();
            if (this.real.isOpen()) {
                try {
                    this.real.close();
                }
                catch (Throwable ignore) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Close failure: {}", (Object)ignore.getMessage());
                }
            }
        }
    }

    public void close(int code, String reason) {
        block3: {
            super.close(code, reason);
            if (this.real.isOpen()) {
                try {
                    this.real.setCloseCode(code);
                    this.real.setCloseReason(reason);
                    this.real.close();
                }
                catch (Throwable ignore) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Close failure: {}", (Object)ignore.getMessage());
                }
            }
        }
    }
}

