/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.undertow;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import org.noear.solon.Utils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.server.ServerLifecycle;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.undertow.UndertowServerBase;
import org.noear.solon.server.undertow.http.UtHttpContextServletHandler;
import org.noear.solon.server.undertow.websocket.UtWsProtocolHandshakeHandler;

public class UndertowServer
extends UndertowServerBase
implements ServerLifecycle {
    protected Undertow _server;
    protected boolean isSecure;
    protected boolean enableWebSocket;

    public UndertowServer(HttpServerProps props) {
        super(props);
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void enableWebSocket(boolean enableWebSocket) {
        this.enableWebSocket = enableWebSocket;
    }

    public void start(String host, int port) throws Throwable {
        this.setup(host, port);
        this._server.start();
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
        }
    }

    protected void setup(String host, int port) throws Throwable {
        HttpHandler httpHandler = this.buildHandler();
        Undertow.Builder builder = Undertow.builder();
        builder.setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false);
        if (ServerProps.request_maxHeaderSize > 0) {
            builder.setServerOption(UndertowOptions.MAX_HEADER_SIZE, (Object)ServerProps.request_maxHeaderSize);
        }
        if (ServerProps.request_maxBodySize > 0L) {
            builder.setServerOption(UndertowOptions.MAX_ENTITY_SIZE, (Object)ServerProps.request_maxFileRequestSize());
        }
        if (ServerProps.request_maxFileSize > 0L) {
            builder.setServerOption(UndertowOptions.MULTIPART_MAX_ENTITY_SIZE, (Object)ServerProps.request_maxFileRequestSize());
        }
        builder.setServerOption(UndertowOptions.IDLE_TIMEOUT, (Object)((int)this.props.getIdleTimeoutOrDefault()));
        builder.setIoThreads(this.props.getCoreThreads());
        builder.setWorkerThreads(this.props.getMaxThreads(this.props.isIoBound()));
        if (this.isEnableHttp2()) {
            builder.setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true);
        }
        if (Utils.isEmpty((String)host)) {
            host = "0.0.0.0";
        }
        if (this.sslConfig.isSslEnable()) {
            builder.addHttpsListener(port, host, this.sslConfig.getSslContext());
            this.isSecure = true;
        } else {
            builder.addHttpListener(port, host);
        }
        for (Integer portAdd : this.addHttpPorts) {
            builder.addHttpListener(portAdd.intValue(), host);
        }
        if (this.enableWebSocket) {
            builder.setHandler((HttpHandler)new UtWsProtocolHandshakeHandler(httpHandler));
        } else {
            builder.setHandler(httpHandler);
        }
        EventBus.publish((Object)builder);
        this._server = builder.build();
    }

    protected HttpHandler buildHandler() throws Exception {
        DeploymentInfo builder = this.initDeploymentInfo();
        builder.addServlet(new ServletInfo("ACTServlet", UtHttpContextServletHandler.class).addMapping("/").setAsyncSupported(true));
        ServletContainer container = Servlets.defaultContainer();
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        return manager.start();
    }
}

