/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.tomcat.integration;

import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.apache.catalina.util.ServerInfo;
import org.apache.jasper.servlet.JasperInitializer;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.prop.impl.WebSocketServerProps;
import org.noear.solon.server.tomcat.TomcatServer;
import org.noear.solon.server.tomcat.TomcatServerJsp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class TomcatPlugin
implements Plugin {
    static final Logger log = LoggerFactory.getLogger(TomcatPlugin.class);
    private static Signal _signal;
    private TomcatServer _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_server_ver() {
        return ServerInfo.getServerInfo() + "/" + Solon.version();
    }

    public void start(final AppContext context) throws Throwable {
        if (!Solon.app().enableHttp()) {
            return;
        }
        context.beanBuilderAdd(WebFilter.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebServlet.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebListener.class, (clz, bw, ano) -> {});
        if (context.isStarted()) {
            this.start0(context);
        } else {
            context.lifecycle(99, new LifecycleBean(){

                public void postStart() throws Throwable {
                    TomcatPlugin.this.start0(context);
                }
            });
        }
    }

    private void start0(AppContext context) throws Throwable {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        ServerProps.init();
        long time_start = System.currentTimeMillis();
        HttpServerProps props = new HttpServerProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        this._server = ClassUtil.hasClass(() -> JasperInitializer.class) ? new TomcatServerJsp(props) : new TomcatServer(props);
        this._server.enableWebSocket(context.app().enableWebSocket());
        EventBus.publish((Object)this._server);
        this._server.start(_host, _port);
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        context.app().signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String connectorInfo = "Connector:main: tomcat: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (this._server.isSecure() && this._server.isEnableHttp2()) {
            connectorInfo = connectorInfo + ";HTTP/2,[http/2]";
        }
        if (context.app().enableWebSocket()) {
            WebSocketServerProps wsProps = WebSocketServerProps.getInstance();
            if (Utils.isNotEmpty((String)wsProps.getName())) {
                SignalSim wsSignal = new SignalSim(wsProps.getName(), _wrapHost, _wrapPort, "ws", SignalType.WEBSOCKET);
                context.app().signalAdd((Signal)wsSignal);
            }
            String wsServerUrl = props.buildWsServerUrl(this._server.isSecure());
            log.info(connectorInfo + "[WebSocket]}{" + wsServerUrl + "}");
        }
        String httpServerUrl = props.buildHttpServerUrl(this._server.isSecure());
        log.info(connectorInfo + "}{" + httpServerUrl + "}");
        log.info("Server:main: tomcat: Started (" + TomcatPlugin.solon_server_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            log.info("Server:main: tomcat: Has Stopped (" + TomcatPlugin.solon_server_ver() + ")");
        }
    }
}

