/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.tomcat.websocket;

import java.util.Collection;
import javax.servlet.ServletContainerInitializer;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.catalina.Context;
import org.apache.tomcat.websocket.server.WsSci;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.noear.solon.server.tomcat.websocket.TcWebSocketConfigurator;
import org.noear.solon.server.tomcat.websocket.TcWebSocketEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcWebSocketManager {
    private static final Logger log = LoggerFactory.getLogger(TcWebSocketManager.class);

    private TcWebSocketManager() {
    }

    public static void init(Context context) {
        if (context == null) {
            log.error("Tomcat Context is null, cannot initialize WebSocket");
            return;
        }
        try {
            context.addServletContainerInitializer((ServletContainerInitializer)new WsSci(), null);
            log.info("Tomcat WebSocket initialized");
        }
        catch (Exception e) {
            log.error("Failed to initialize Tomcat WebSocket", (Throwable)e);
        }
    }

    public static void registerEndpoints(Context context) {
        if (context == null) {
            log.error("Tomcat Context is null, cannot register WebSocket endpoints");
            return;
        }
        try {
            ServerContainer serverContainer = (ServerContainer)context.getServletContext().getAttribute("javax.websocket.server.ServerContainer");
            if (serverContainer == null) {
                log.error("Tomcat Context Missing javax.websocket.server.ServerContainer");
                return;
            }
            Collection paths = WebSocketRouter.getInstance().getPaths();
            for (String path : paths) {
                if (!path.startsWith("/")) continue;
                ServerEndpointConfig endpointConfig = ServerEndpointConfig.Builder.create(TcWebSocketEndpoint.class, (String)path).configurator((ServerEndpointConfig.Configurator)new TcWebSocketConfigurator()).build();
                serverContainer.addEndpoint(endpointConfig);
                log.info("Tomcat Registered WebSocket endpoint: {}", (Object)path);
            }
        }
        catch (Throwable e) {
            log.error("Failed to register Tomcat WebSocket endpoints", e);
        }
    }
}

