/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.tomcat.websocket;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.noear.solon.Utils;
import org.noear.solon.net.websocket.SubProtocolCapable;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.noear.solon.server.util.DecodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcWebSocketConfigurator
extends ServerEndpointConfig.Configurator {
    private static final Logger log = LoggerFactory.getLogger(TcWebSocketConfigurator.class);

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        String protocols;
        List clientProtocols;
        sec.getUserProperties().put("handshakeRequest", request);
        String path = DecodeUtils.rinseUri((String)request.getRequestURI().getPath());
        SubProtocolCapable subProtocolCapable = WebSocketRouter.getInstance().getSubProtocol(path);
        if (subProtocolCapable != null && (clientProtocols = (List)request.getHeaders().get("Sec-WebSocket-Protocol")) != null && !clientProtocols.isEmpty() && Utils.isNotEmpty((String)(protocols = subProtocolCapable.getSubProtocols((Collection)clientProtocols)))) {
            response.getHeaders().put("Sec-WebSocket-Protocol", Arrays.asList(protocols));
        }
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            sec.getUserProperties().put("header." + (String)entry.getKey(), ((List)entry.getValue()).get(0));
        }
    }

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        try {
            return endpointClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("Tomcat WebSocket Failed to create endpoint instance: {}", (Object)endpointClass.getName(), (Object)e);
            throw new InstantiationException("Tomcat WebSocket Failed to create endpoint instance: " + e.getMessage());
        }
    }
}

