/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.tomcat.websocket;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.websocket.CloseReason;
import javax.websocket.Session;
import org.noear.solon.net.websocket.WebSocketBase;
import org.noear.solon.server.util.DecodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketImpl
extends WebSocketBase {
    private static final Logger log = LoggerFactory.getLogger(WebSocketImpl.class);
    private final Session real;

    public WebSocketImpl(Session real) {
        this.real = real;
        String uri = DecodeUtils.rinseUri((String)real.getRequestURI().toString());
        this.init(URI.create(uri));
        for (String key : real.getUserProperties().keySet()) {
            if (!key.startsWith("header.")) continue;
            String headerName = key.substring(7);
            Object value = real.getUserProperties().get(key);
            if (!(value instanceof String)) continue;
            this.param(headerName, (String)value);
        }
    }

    public boolean isValid() {
        return !this.isClosed() && this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.isSecure();
    }

    public InetSocketAddress remoteAddress() {
        return null;
    }

    public InetSocketAddress localAddress() {
        return null;
    }

    public long getIdleTimeout() {
        return this.real.getMaxIdleTimeout();
    }

    public void setIdleTimeout(long idleTimeout) {
        this.real.setMaxIdleTimeout(idleTimeout);
    }

    public Future<Void> send(String text) {
        return this.real.getAsyncRemote().sendText(text);
    }

    public Future<Void> send(ByteBuffer binary) {
        return this.real.getAsyncRemote().sendBinary(binary);
    }

    public void close() {
        block2: {
            super.close();
            try {
                this.real.close();
            }
            catch (Throwable ignore) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Close failure: {}", (Object)ignore.getMessage());
            }
        }
    }

    public void close(int code, String reason) {
        block2: {
            super.close(code, reason);
            try {
                this.real.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)code), reason));
            }
            catch (Throwable ignore) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Close failure: {}", (Object)ignore.getMessage());
            }
        }
    }
}

