/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.tomcat.websocket;

import java.util.Collection;
import javax.servlet.ServletContainerInitializer;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.catalina.Context;
import org.apache.tomcat.websocket.server.WsSci;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.noear.solon.server.tomcat.websocket.TcWebSocketEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcWebSocketManager {
    private static final Logger log = LoggerFactory.getLogger(TcWebSocketManager.class);
    private static boolean enableWebSocket = false;

    private TcWebSocketManager() {
    }

    public static void init(Context context) {
        try {
            context.addServletContainerInitializer((ServletContainerInitializer)new WsSci(), null);
            enableWebSocket = true;
            log.info("Tomcat WebSocket initialized");
        }
        catch (Exception e) {
            log.error("Failed to initialize Tomcat WebSocket", (Throwable)e);
        }
    }

    public static void registerEndpoints(Context context) {
        try {
            if (context == null) {
                log.error("Tomcat Context is null, cannot register WebSocket endpoints");
                return;
            }
            ServerContainer serverContainer = (ServerContainer)context.getServletContext().getAttribute("javax.websocket.server.ServerContainer");
            if (serverContainer == null) {
                throw new IllegalStateException("Missing javax.websocket.server.ServerContainer");
            }
            Collection paths = WebSocketRouter.getInstance().getPaths();
            for (String path : paths) {
                if (!path.startsWith("/")) continue;
                ServerEndpointConfig endpointConfig = ServerEndpointConfig.Builder.create(TcWebSocketEndpoint.class, (String)path).build();
                serverContainer.addEndpoint(endpointConfig);
                log.info("Tomcat Registered WebSocket endpoint: {}", (Object)path);
            }
        }
        catch (Throwable e) {
            log.error("Failed to register WebSocket endpoints", e);
            throw new RuntimeException(e);
        }
    }

    public static boolean isEnableWebSocket() {
        return enableWebSocket;
    }
}

