/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.tomcat;

import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.handle.SessionProps;
import org.noear.solon.server.tomcat.TomcatServerBase;
import org.noear.solon.server.tomcat.http.TCHttpContextHandler;

public class TomcatServer
extends TomcatServerBase {
    @Override
    protected Connector addConnector(int port) throws Throwable {
        Connector connector = this._server.getConnector();
        connector.setPort(port);
        connector.setMaxPostSize(ServerProps.request_maxBodySizeAsInt());
        connector.setProperty("maxHttpHeaderSize", String.valueOf(ServerProps.request_maxHeaderSize));
        connector.setProperty("relaxedQueryChars", "[]|{}");
        connector.setURIEncoding(ServerProps.request_encoding);
        connector.setUseBodyEncodingForURI(true);
        return connector;
    }

    @Override
    protected Context initContext() {
        Context context = this._server.addContext("/", null);
        String _tempdir = IoUtil.getTempDirAsString((String)"solon-server");
        MultipartConfigElement multipartConfig = new MultipartConfigElement(_tempdir, ServerProps.request_maxFileSize, ServerProps.request_maxFileRequestSize(), ServerProps.request_fileSizeThreshold);
        context.getServletContext().setAttribute("org.apache.catalina.MultipartConfigElement", (Object)multipartConfig);
        context.setAllowCasualMultipartParsing(true);
        if (SessionProps.session_timeout > 0) {
            context.setSessionTimeout(SessionProps.session_timeout);
        }
        Tomcat.addServlet((Context)context, (String)"solon", (Servlet)new TCHttpContextHandler()).setAsyncSupported(true);
        context.addServletMappingDecoded("/", "solon");
        return context;
    }
}

