/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.socketd.integration;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import org.noear.socketd.SocketD;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.transport.server.ServerConfigHandler;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.socketd.SocketdRouter;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.prop.impl.SocketServerProps;
import org.noear.solon.server.ssl.SslConfig;

public class SocketdPlugin
implements Plugin {
    private List<Server> serverList = new ArrayList<Server>();
    private SocketdRouter socketdRouter;
    private ServerConfigHandler serverConfigHandler;

    public void start(final AppContext context) throws Throwable {
        if (!context.app().enableSocketD()) {
            return;
        }
        if (context.isStarted()) {
            this.start0(context);
        } else {
            context.lifecycle(99, new LifecycleBean(){

                public void postStart() throws Throwable {
                    SocketdPlugin.this.start0(context);
                }
            });
        }
    }

    private void start0(AppContext context) throws Throwable {
        this.socketdRouter = SocketdRouter.getInstance();
        this.serverConfigHandler = (ServerConfigHandler)context.getBean(ServerConfigHandler.class);
        ServerProps.init();
        SslConfig sslConfig = new SslConfig("socket");
        SSLContext sslContext = sslConfig.isSslEnable() ? sslConfig.getSslContext() : null;
        SocketServerProps serverProps = new SocketServerProps(20000);
        ExecutorService exchangeExecutor = serverProps.newWorkExecutor("Socketd-channelExecutor-");
        Server serverTmp = SocketD.createServerOrNull((String)"sd:tcp");
        if (serverTmp != null) {
            serverTmp.config(c -> {
                ServerConfig cfr_ignored_0 = (ServerConfig)((ServerConfig)c.exchangeExecutor(exchangeExecutor)).sslContext(sslContext);
            });
            EventBus.publish((Object)serverTmp);
            this.startServer1(context, serverTmp, serverProps, 0);
        }
        if ((serverTmp = SocketD.createServerOrNull((String)"sd:udp")) != null) {
            serverTmp.config(c -> {
                ServerConfig cfr_ignored_0 = (ServerConfig)((ServerConfig)c.exchangeExecutor(exchangeExecutor)).sslContext(sslContext);
            });
            EventBus.publish((Object)serverTmp);
            this.startServer1(context, serverTmp, serverProps, 1);
        }
        if ((serverTmp = SocketD.createServerOrNull((String)"sd:ws")) != null) {
            serverTmp.config(c -> {
                ServerConfig cfr_ignored_0 = (ServerConfig)((ServerConfig)c.exchangeExecutor(exchangeExecutor)).sslContext(sslContext);
            });
            EventBus.publish((Object)serverTmp);
            this.startServer1(context, serverTmp, serverProps, 2);
        }
        if (this.serverList.size() == 0) {
            exchangeExecutor.shutdown();
            LogUtil.global().warn("Missing socketd server provider!");
        }
    }

    private void startServer1(AppContext context, Server server, SocketServerProps serverProps, int portAdd) throws Exception {
        long time_start = System.currentTimeMillis();
        int portReal = serverProps.getPort() + portAdd;
        this.serverList.add(server);
        server.config(c -> c.port(portReal).host(serverProps.getHost()));
        server.listen(this.socketdRouter.getListener());
        if (this.serverConfigHandler != null) {
            server.config(this.serverConfigHandler);
        }
        EventBus.publish((Object)server);
        server.start();
        if (Utils.isNotEmpty((String)serverProps.getName())) {
            String _wrapHost = serverProps.getWrapHost();
            int _wrapPort = serverProps.getWrapPort() + portAdd;
            SignalSim _signal = new SignalSim(serverProps.getName(), _wrapHost, _wrapPort, "socketd", SignalType.SOCKET);
            context.app().signalAdd((Signal)_signal);
        }
        long time_end = System.currentTimeMillis();
        String serverUrl = server.getConfig().getSchema() + "://localhost:" + portReal;
        LogUtil.global().info("Connector:main: socket.d: Started ServerConnector@{" + serverUrl + "}");
        LogUtil.global().info("Server:main: socket.d: Started (" + server.getTitle() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        for (Server server : this.serverList) {
            RunUtil.runAndTry(() -> ((Server)server).stop());
        }
    }
}

