/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.smarthttp.websocket;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.noear.solon.Utils;
import org.noear.solon.net.websocket.WebSocketTimeoutBase;
import org.noear.solon.server.util.DecodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.http.server.WebSocketRequest;
import org.smartboot.http.server.WebSocketResponse;
import org.smartboot.http.server.impl.WebSocketRequestImpl;

public class WebSocketImpl
extends WebSocketTimeoutBase {
    private static final Logger log = LoggerFactory.getLogger(WebSocketImpl.class);
    private final WebSocketRequestImpl request;
    private final WebSocketResponse real;

    public WebSocketImpl(WebSocketRequest request) {
        this.request = (WebSocketRequestImpl)request;
        this.real = this.request.getResponse();
        String uri = this.buildUri(request);
        this.init(URI.create(uri));
    }

    public String buildUri(WebSocketRequest req) {
        if (Utils.isEmpty((String)req.getQueryString())) {
            return DecodeUtils.rinseUri((String)req.getRequestURL());
        }
        if (req.getRequestURL().contains("?")) {
            return DecodeUtils.rinseUri((String)req.getRequestURL());
        }
        return DecodeUtils.rinseUri((String)req.getRequestURL()) + "?" + req.getQueryString();
    }

    public boolean isValid() {
        return !this.isClosed();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public InetSocketAddress remoteAddress() {
        return this.request.getRemoteAddress();
    }

    public InetSocketAddress localAddress() {
        return this.request.getLocalAddress();
    }

    public Future<Void> send(String text) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.real.sendTextMessage(text);
            this.real.flush();
            this.onSend();
            future.complete(null);
        }
        catch (Throwable ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    public Future<Void> send(ByteBuffer binary) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.real.sendBinaryMessage(binary.array());
            this.real.flush();
            this.onSend();
            future.complete(null);
        }
        catch (Throwable ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    public void close() {
        block2: {
            super.close();
            try {
                this.real.close();
            }
            catch (Throwable ignore) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Close failure: {}", (Object)ignore.getMessage());
            }
        }
    }

    public void close(int code, String reason) {
        block2: {
            super.close(code, reason);
            try {
                this.real.close(code, reason);
            }
            catch (Throwable ignore) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Close failure: {}", (Object)ignore.getMessage());
            }
        }
    }
}

