/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.smarthttp.integration;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.prop.impl.WebSocketServerProps;
import org.noear.solon.server.smarthttp.SmHttpServerComb;
import org.noear.solon.server.smarthttp.http.MultipartUtil;

public final class SmHttpPlugin
implements Plugin {
    private static Signal _signal;
    private SmHttpServerComb _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_server_ver() {
        return "smart http 2.5/" + Solon.version();
    }

    public void start(final AppContext context) throws Throwable {
        if (!context.app().enableHttp()) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.server.jetty.integration.JettyPlugin") != null) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.server.undertow.integration.UndertowPlugin") != null) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.server.vertx.integration.VxHttpPlugin") != null) {
            return;
        }
        if (context.isStarted()) {
            this.start0(context);
        } else {
            context.lifecycle(99, new LifecycleBean(){

                public void postStart() throws Throwable {
                    SmHttpPlugin.this.start0(context);
                }
            });
        }
    }

    private void start0(AppContext context) throws Throwable {
        ServerProps.init();
        MultipartUtil.init();
        HttpServerProps props = new HttpServerProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        this._server = new SmHttpServerComb(props);
        this._server.enableWebSocket(context.app().enableWebSocket());
        this._server.setCoreThreads(props.getCoreThreads());
        if (props.isIoBound()) {
            this._server.setExecutor(props.newWorkExecutor("smarthttp-"));
        }
        this._server.setHandler(arg_0 -> ((SolonApp)context.app()).tryHandle(arg_0));
        EventBus.publish((Object)this._server);
        this._server.start(_host, _port);
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        context.app().signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String connectorInfo = "solon.connector:main: smarthttp: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (context.app().enableWebSocket()) {
            WebSocketServerProps wsProps = WebSocketServerProps.getInstance();
            if (Utils.isNotEmpty((String)wsProps.getName())) {
                SignalSim wsSignal = new SignalSim(wsProps.getName(), _wrapHost, _wrapPort, "ws", SignalType.WEBSOCKET);
                context.app().signalAdd((Signal)wsSignal);
            }
            String wsServerUrl = props.buildWsServerUrl(this._server.isSecure());
            LogUtil.global().info(connectorInfo + "[WebSocket]}{" + wsServerUrl + "}");
        }
        String httpServerUrl = props.buildHttpServerUrl(this._server.isSecure());
        LogUtil.global().info(connectorInfo + "}{" + httpServerUrl + "}");
        LogUtil.global().info("Server:main: smarthttp: Started (" + SmHttpPlugin.solon_server_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            LogUtil.global().info("Server:main: smarthttp: Has Stopped (" + SmHttpPlugin.solon_server_ver() + ")");
        }
    }
}

