/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.smarthttp.http;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.smarthttp.http.SmHttpContext;
import org.noear.solon.server.smarthttp.integration.SmHttpPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.impl.Request;
import org.smartboot.socket.util.AttachKey;
import org.smartboot.socket.util.Attachment;

public class SmHttpContextHandler
extends HttpServerHandler {
    static final Logger log = LoggerFactory.getLogger(SmHttpContextHandler.class);
    static final AttachKey<SmHttpContext> httpHolderKey = AttachKey.valueOf((String)"httpHolder");
    protected Executor executor;
    private final Handler handler;

    public SmHttpContextHandler(Handler handler) {
        this.handler = handler;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(Request request) {
        if (request.getAttachment() == null) {
            return;
        }
        SmHttpContext ctx = (SmHttpContext)((Object)request.getAttachment().get(httpHolderKey));
        if (ctx != null && ctx.asyncStarted()) {
            try {
                try {
                    ctx.asyncState.onComplete((Context)ctx);
                }
                catch (Throwable e) {
                    log.warn(e.getMessage(), e);
                }
            }
            finally {
                request.getAttachment().remove(httpHolderKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpRequest request, HttpResponse response, CompletableFuture<Object> future) throws IOException {
        SmHttpContext ctx = new SmHttpContext(request, response, future);
        if (request.getAttachment() == null) {
            request.setAttachment(new Attachment());
        }
        request.getAttachment().put(httpHolderKey, (Object)ctx);
        try {
            if (this.executor == null) {
                this.handle0(ctx, future);
            } else {
                try {
                    this.executor.execute(() -> this.handle0(ctx, future));
                }
                catch (RejectedExecutionException e) {
                    this.handle0(ctx, future);
                }
            }
        }
        finally {
            if (!ctx.asyncStarted()) {
                request.getAttachment().remove(httpHolderKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle0(SmHttpContext ctx, CompletableFuture<Object> future) {
        try {
            this.handleDo(ctx);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (!ctx.asyncStarted()) {
                future.complete((Object)ctx);
            }
        }
    }

    protected void handleDo(SmHttpContext ctx) {
        try {
            if ("PRI".equals(ctx.method())) {
                ctx.innerGetResponse().setHttpStatus(HttpStatus.NOT_IMPLEMENTED);
                return;
            }
            ctx.contentType("text/plain;charset=UTF-8");
            if (ServerProps.output_meta) {
                ctx.headerSet("Solon-Boot", SmHttpPlugin.solon_boot_ver());
            }
            this.handler.handle((Context)ctx);
            if (!ctx.asyncStarted()) {
                ctx.innerCommit();
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
            ctx.innerGetResponse().setHttpStatus(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

