/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.jetty.integration;

import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.eclipse.jetty.jsp.JettyJspServlet;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.jetty.JettyServer;
import org.noear.solon.server.jetty.JettyServerAddJsp;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.prop.impl.WebSocketServerProps;

public final class JettyPlugin
implements Plugin {
    private static Signal _signal;
    private JettyServer _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_server_ver() {
        return "jetty 9.4/" + Solon.version();
    }

    public void start(final AppContext context) throws Throwable {
        if (!context.app().enableHttp()) {
            return;
        }
        context.beanBuilderAdd(WebFilter.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebServlet.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebListener.class, (clz, bw, ano) -> {});
        if (context.isStarted()) {
            this.start0(context);
        } else {
            context.lifecycle(99, new LifecycleBean(){

                public void postStart() throws Throwable {
                    JettyPlugin.this.start0(context);
                }
            });
        }
    }

    private void start0(AppContext context) throws Throwable {
        ServerProps.init();
        if (ServerProps.request_maxBodySize > 0L) {
            System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", String.valueOf(ServerProps.request_maxBodySize));
        }
        HttpServerProps props = new HttpServerProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        this._server = ClassUtil.hasClass(() -> JettyJspServlet.class) ? new JettyServerAddJsp(props) : new JettyServer(props);
        this._server.enableWebSocket(context.app().enableWebSocket());
        this._server.enableSessionState(context.app().enableSessionState());
        long time_start = System.currentTimeMillis();
        EventBus.publish((Object)this._server);
        this._server.start(_host, _port);
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        context.app().signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String connectorInfo = "Connector:main: jetty: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (context.app().enableWebSocket()) {
            WebSocketServerProps wsProps = WebSocketServerProps.getInstance();
            if (Utils.isNotEmpty((String)wsProps.getName())) {
                SignalSim wsSignal = new SignalSim(wsProps.getName(), _wrapHost, _wrapPort, "ws", SignalType.WEBSOCKET);
                context.app().signalAdd((Signal)wsSignal);
            }
            String wsServerUrl = props.buildWsServerUrl(this._server.isSecure());
            LogUtil.global().info(connectorInfo + "[WebSocket]}{" + wsServerUrl + "}");
        }
        String httpServerUrl = props.buildHttpServerUrl(this._server.isSecure());
        LogUtil.global().info(connectorInfo + "}{" + httpServerUrl + "}");
        LogUtil.global().info("Server:main: jetty: Started (" + JettyPlugin.solon_server_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            LogUtil.global().info("Server:main: jetty: Has Stopped (" + JettyPlugin.solon_server_ver() + ")");
        }
    }
}

