/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.jdkhttp.integration;

import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.jdkhttp.JdkHttpServerComb;
import org.noear.solon.server.prop.impl.HttpServerProps;

public final class JdkHttpPlugin
implements Plugin {
    private static Signal _signal;
    JdkHttpServerComb _server;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "jdk http/" + Solon.version();
    }

    public void start(final AppContext context) throws Throwable {
        if (!context.app().enableHttp()) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.server.jetty.integration.JettyPlugin") != null) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.server.undertow.integration.UndertowPlugin") != null) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.server.vertx.integration.VxHttpPlugin") != null) {
            return;
        }
        if (ClassUtil.loadClass((String)"org.noear.solon.server.smarthttp.integration.SmHttpPlugin") != null) {
            return;
        }
        if (context.isStarted()) {
            this.start0(context);
        } else {
            context.lifecycle(99, new LifecycleBean(){

                public void postStart() throws Throwable {
                    JdkHttpPlugin.this.start0(context);
                }
            });
        }
    }

    private void start0(AppContext context) throws Throwable {
        ServerProps.init();
        HttpServerProps props = new HttpServerProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        this._server = new JdkHttpServerComb();
        this._server.setExecutor(props.newWorkExecutor("jdkhttp-"));
        this._server.setHandler(arg_0 -> ((SolonApp)context.app()).tryHandle(arg_0));
        EventBus.publish((Object)this._server);
        this._server.start(_host, _port);
        String _wrapHost = props.getWrapHost();
        int _wrapPort = props.getWrapPort();
        _signal = new SignalSim(_name, _wrapHost, _wrapPort, "http", SignalType.HTTP);
        context.app().signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String httpServerUrl = props.buildHttpServerUrl(this._server.isSecure());
        LogUtil.global().info("Connector:main: jdkhttp: Started ServerConnector@{HTTP/1.1,[http/1.1]}{" + httpServerUrl + "}");
        LogUtil.global().info("Server:main: jdkhttp: Started (" + JdkHttpPlugin.solon_boot_ver() + ") @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.stop();
        this._server = null;
        LogUtil.global().info("Server:main: jdkhttp: Has Stopped (" + JdkHttpPlugin.solon_boot_ver() + ")");
    }
}

