/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.grizzly.websocket;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.noear.solon.Utils;
import org.noear.solon.net.websocket.SubProtocolCapable;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.noear.solon.server.grizzly.websocket.GyWebSocket;
import org.noear.solon.server.grizzly.websocket.GyWebSocketListenerImpl;

public class GyWebSocketApplication
extends WebSocketApplication {
    private static final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public WebSocket createSocket(ProtocolHandler handler, HttpRequestPacket requestPacket, WebSocketListener ... listeners) {
        GyWebSocket gyWebSocket = new GyWebSocket(handler, requestPacket, listeners);
        gyWebSocket.add(new GyWebSocketListenerImpl());
        return gyWebSocket;
    }

    protected void handshake(HandShake handshake) throws HandshakeException {
        String protocols;
        super.handshake(handshake);
        String path = handshake.getResourcePath();
        SubProtocolCapable subProtocolCapable = webSocketRouter.getSubProtocol(path);
        if (subProtocolCapable != null && Utils.isNotEmpty((String)(protocols = subProtocolCapable.getSubProtocols((Collection)handshake.getSubProtocol())))) {
            handshake.setSubProtocol(Arrays.asList(protocols.split(",")));
        }
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        return subProtocol;
    }

    protected boolean onError(WebSocket socket, Throwable t) {
        GyWebSocket gyWebSocket = (GyWebSocket)socket;
        webSocketRouter.getListener().onError(gyWebSocket.attachment, t);
        return super.onError(socket, t);
    }
}

