/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.grizzly.http;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.grizzly.http.GyHttpContext;
import org.noear.solon.server.grizzly.integration.GyHttpPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GyHttpContextHandler
extends HttpHandler {
    static final Logger log = LoggerFactory.getLogger(GyHttpContextHandler.class);
    protected Executor executor;
    private final Handler handler;

    public GyHttpContextHandler(Handler handler) {
        this.handler = handler;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request request, Response response) throws Exception {
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(ServerProps.request_encoding);
        }
        GyHttpContext ctx = new GyHttpContext(request, response);
        try {
            if (this.executor == null) {
                this.handle0(ctx);
            } else {
                try {
                    this.executor.execute(() -> this.handle0(ctx));
                }
                catch (RejectedExecutionException e) {
                    this.handle0(ctx);
                }
            }
        }
        finally {
            if (!ctx.asyncStarted()) {
                // empty if block
            }
        }
    }

    protected void handle0(GyHttpContext ctx) {
        try {
            this.handleDo(ctx);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (!ctx.asyncStarted()) {
                ctx.innerGetResponse().finish();
            }
        }
    }

    protected void handleDo(GyHttpContext ctx) {
        try {
            if ("PRI".equals(ctx.method())) {
                ctx.innerGetResponse().setStatus(HttpStatus.NOT_IMPLEMENTED_501);
                return;
            }
            if (ServerProps.output_meta) {
                ctx.headerSet("Solon-Server", GyHttpPlugin.solon_server_ver());
            }
            this.handler.handle((Context)ctx);
            if (!ctx.asyncStarted()) {
                ctx.innerCommit();
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
            ctx.innerGetResponse().setStatus(500);
        }
    }
}

