/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.prop;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import org.noear.solon.Utils;
import org.noear.solon.serialization.EntityStringSerializer;
import org.noear.solon.serialization.prop.JsonProps;

public class JsonPropsUtil2 {
    public static boolean apply(EntityStringSerializer serializer, JsonProps jsonProps) {
        if (jsonProps == null) {
            return false;
        }
        JsonPropsUtil2.dateAsFormat(serializer, jsonProps);
        JsonPropsUtil2.dateAsTicks(serializer, jsonProps);
        JsonPropsUtil2.boolAsInt(serializer, jsonProps);
        return true;
    }

    public static void boolAsInt(EntityStringSerializer serializer, JsonProps jsonProps) {
        if (jsonProps == null) {
            return;
        }
        if (jsonProps.boolAsInt) {
            serializer.addEncoder(Boolean.class, e -> e != false ? 1 : 0);
            serializer.addEncoder(Boolean.TYPE, e -> e != false ? 1 : 0);
        }
    }

    public static void longAsString(EntityStringSerializer serializer, JsonProps jsonProps) {
        if (jsonProps == null) {
            return;
        }
        if (jsonProps.longAsString) {
            serializer.addEncoder(Long.class, String::valueOf);
            serializer.addEncoder(Long.TYPE, String::valueOf);
        }
    }

    public static void dateAsTicks(EntityStringSerializer serializer, JsonProps jsonProps) {
        if (jsonProps == null) {
            return;
        }
        if (jsonProps.dateAsTicks) {
            serializer.addEncoder(Date.class, d -> {
                if (jsonProps.longAsString) {
                    return String.valueOf(d.getTime());
                }
                return d.getTime();
            });
        }
    }

    public static void dateAsFormat(EntityStringSerializer serializer, JsonProps jsonProps) {
        if (jsonProps == null) {
            return;
        }
        if (Utils.isNotEmpty((String)jsonProps.dateAsFormat)) {
            serializer.addEncoder(Date.class, e -> {
                SimpleDateFormat df = new SimpleDateFormat(jsonProps.dateAsFormat);
                if (Utils.isNotEmpty((String)jsonProps.dateAsTimeZone)) {
                    df.setTimeZone(TimeZone.getTimeZone(ZoneId.of(jsonProps.dateAsTimeZone)));
                }
                return df.format((Date)e);
            });
            serializer.addEncoder(OffsetDateTime.class, e -> {
                DateTimeFormatter df = DateTimeFormatter.ofPattern(jsonProps.dateAsFormat);
                if (Utils.isNotEmpty((String)jsonProps.dateAsTimeZone)) {
                    df.withZone(ZoneId.of(jsonProps.dateAsTimeZone));
                }
                return e.format(df);
            });
            serializer.addEncoder(ZonedDateTime.class, e -> {
                DateTimeFormatter df = DateTimeFormatter.ofPattern(jsonProps.dateAsFormat);
                if (Utils.isNotEmpty((String)jsonProps.dateAsTimeZone)) {
                    df.withZone(ZoneId.of(jsonProps.dateAsTimeZone));
                }
                return e.format(df);
            });
            serializer.addEncoder(LocalDateTime.class, e -> JsonPropsUtil2.formatLocalDateTime(e, jsonProps));
            serializer.addEncoder(LocalDate.class, e -> JsonPropsUtil2.formatLocalDateTime(e.atStartOfDay(), jsonProps));
        }
    }

    private static String formatLocalDateTime(LocalDateTime e, JsonProps jsonProps) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(jsonProps.dateAsFormat);
        if (Utils.isNotEmpty((String)jsonProps.dateAsTimeZone)) {
            df.withZone(ZoneId.of(jsonProps.dateAsTimeZone));
        }
        return e.format(df);
    }
}

