/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization;

import org.noear.solon.core.handle.AbstractEntityConverter;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.Assert;
import org.noear.solon.serialization.EntitySerializer;
import org.noear.solon.serialization.SerializationConfig;

public abstract class AbstractStringEntityConverter<T extends EntitySerializer<String>>
extends AbstractEntityConverter {
    protected final T serializer;

    public T getSerializer() {
        return this.serializer;
    }

    public AbstractStringEntityConverter(T serializer) {
        Assert.notNull(serializer, (String)"Serializer not be null");
        this.serializer = serializer;
    }

    protected boolean isWriteType() {
        return false;
    }

    public boolean allowWrite() {
        return true;
    }

    public boolean canWrite(String mime, Context ctx) {
        return this.serializer.matched(ctx, mime);
    }

    public String writeAndReturn(Object data, Context ctx) throws Throwable {
        return (String)this.serializer.serialize(data);
    }

    public void write(Object data, Context ctx) throws Throwable {
        if (SerializationConfig.isOutputMeta()) {
            ctx.headerAdd("solon.serialization", this.name());
        }
        String text = null;
        if (this.isWriteType()) {
            text = (String)this.serializer.serialize(data);
        } else {
            if (data == null) {
                return;
            }
            if (data instanceof Throwable) {
                throw (Throwable)data;
            }
            text = (String)this.serializer.serialize(data);
        }
        ctx.attrSet("output", (Object)text);
        this.doWrite(ctx, data, text);
    }

    protected void doWrite(Context ctx, Object data, String text) {
        if (data instanceof String && !this.isWriteType()) {
            ctx.output(text);
        } else {
            if (ctx.contentTypeNew() == null) {
                ctx.contentType(this.serializer.mimeType());
            }
            ctx.output(text);
        }
    }

    public boolean allowRead() {
        return true;
    }

    public boolean canRead(Context ctx, String mime) {
        return this.serializer.matched(ctx, mime);
    }
}

