/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.properties;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Properties;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.Options;
import org.noear.snack4.codec.KeyValueList;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.EntitySerializer;

public class PropertiesStringSerializer
implements EntitySerializer<String> {
    private static final PropertiesStringSerializer _default = new PropertiesStringSerializer();
    private boolean allowGet = true;
    private boolean allowPostForm = false;
    private Options config;

    public static PropertiesStringSerializer getDefault() {
        return _default;
    }

    public boolean allowGet() {
        return this.allowGet;
    }

    public boolean allowPostForm() {
        return this.allowPostForm;
    }

    public void allowGet(boolean allowGet) {
        this.allowGet = allowGet;
    }

    public void allowPostForm(boolean allowPostForm) {
        this.allowPostForm = allowPostForm;
    }

    public Options getConfig() {
        if (this.config == null) {
            this.config = Options.of((Feature[])new Feature[0]);
        }
        return this.config;
    }

    public void setConfig(Options config) {
        if (config != null) {
            this.config = config;
        }
    }

    public String mimeType() {
        return "application/properties";
    }

    public Class<String> dataType() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        return false;
    }

    public String name() {
        return "properties-string";
    }

    public String serialize(Object obj) throws IOException {
        ONode oNode = ONode.ofBean((Object)obj, (Options)this.getConfig());
        Properties oProperties = (Properties)oNode.toBean(Properties.class);
        StringBuilder buf = new StringBuilder();
        ArrayList<String> bufKeys = new ArrayList<String>(oProperties.stringPropertyNames());
        bufKeys.sort(String::compareTo);
        for (String key : bufKeys) {
            buf.append(key).append("=").append(oProperties.getProperty(key)).append("\n");
        }
        return buf.toString();
    }

    public Object deserialize(String data, Type toType) throws IOException {
        Properties prop = Utils.buildProperties((String)data);
        if (toType == null) {
            return prop;
        }
        ONode oNode = ONode.ofBean((Object)prop, (Options)this.getConfig());
        return oNode.toBean(toType);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        KeyValueList nameValues = new KeyValueList();
        for (KeyValues kv : ctx.paramMap()) {
            for (String val : kv.getValues()) {
                nameValues.add(kv.getKey(), val);
            }
        }
        return ONode.ofBean((Object)nameValues, (Options)this.getConfig());
    }
}

