/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.properties;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Properties;
import org.noear.snack.ONode;
import org.noear.snack.core.NameValues;
import org.noear.snack.core.Options;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.ContextSerializer;

public class PropertiesStringSerializer
implements ContextSerializer<String> {
    private Options config;

    public Options getConfig() {
        if (this.config == null) {
            this.config = Options.def();
        }
        return this.config;
    }

    public void setConfig(Options config) {
        if (config != null) {
            this.config = config;
        }
    }

    public String mimeType() {
        return "application/properties";
    }

    public Class<String> dataType() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        return false;
    }

    public String name() {
        return "properties-string";
    }

    public String serialize(Object obj) throws IOException {
        ONode oNode = ONode.loadObj((Object)obj, (Options)this.getConfig());
        Properties oProperties = (Properties)oNode.toObject(Properties.class);
        StringBuilder buf = new StringBuilder();
        ArrayList<String> bufKeys = new ArrayList<String>(oProperties.stringPropertyNames());
        bufKeys.sort(String::compareTo);
        for (String key : bufKeys) {
            buf.append(key).append("=").append(oProperties.getProperty(key)).append("\n");
        }
        return buf.toString();
    }

    public Object deserialize(String data, Type toType) throws IOException {
        Properties prop = Utils.buildProperties((String)data);
        if (toType == null) {
            return prop;
        }
        ONode oNode = ONode.loadObj((Object)prop, (Options)this.getConfig());
        return oNode.toObject(toType);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        NameValues nameValues = new NameValues();
        for (KeyValues kv : ctx.paramMap()) {
            for (String val : kv.getValues()) {
                nameValues.add(kv.getKey(), val);
            }
        }
        return ONode.loadObj((Object)nameValues, (Options)this.getConfig());
    }
}

