/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson3;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.solon.Utils;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.EntityStringSerializer;
import org.noear.solon.serialization.jackson3.Jackson3Decl;
import org.noear.solon.serialization.jackson3.impl.NullValueSerializerImpl;
import org.noear.solon.serialization.jackson3.impl.TypeReferenceImpl;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil2;
import tools.jackson.core.FormatFeature;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.json.JsonReadFeature;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.EnumFeature;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.ser.jdk.JavaUtilDateSerializer;

public class Jackson3StringSerializer
implements EntityStringSerializer {
    private static final String label = "/json";
    private static final Jackson3StringSerializer _default = new Jackson3StringSerializer();
    private Jackson3Decl<SerializationFeature> serializeConfig;
    private Jackson3Decl<DeserializationFeature> deserializeConfig;
    private AtomicBoolean initStatus = new AtomicBoolean(false);

    public static Jackson3StringSerializer getDefault() {
        return _default;
    }

    public Jackson3StringSerializer(JsonProps jsonProps) {
        this.loadJsonProps(jsonProps);
    }

    public Jackson3StringSerializer() {
    }

    public Jackson3Decl<SerializationFeature> getSerializeConfig() {
        if (this.serializeConfig == null) {
            this.serializeConfig = new Jackson3Decl();
        }
        return this.serializeConfig;
    }

    public Jackson3Decl<DeserializationFeature> getDeserializeConfig() {
        if (this.deserializeConfig == null) {
            this.deserializeConfig = new Jackson3Decl();
        }
        return this.deserializeConfig;
    }

    public void refresh() {
        this.initStatus.set(false);
    }

    protected void init() {
        if (this.initStatus.compareAndSet(false, true)) {
            this.getSerializeConfig().refresh();
            this.getDeserializeConfig().refresh();
        }
    }

    public String mimeType() {
        return "application/json";
    }

    public Class<String> dataType() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label) || mime.startsWith("application/x-ndjson");
    }

    public String name() {
        return "jackson-json";
    }

    public String serialize(Object obj) throws IOException {
        this.init();
        return this.getSerializeConfig().getMapper().writeValueAsString(obj);
    }

    public Object deserialize(String data, Type toType) throws IOException {
        Class toClz;
        this.init();
        if (toType == null) {
            return this.getDeserializeConfig().getMapper().readTree(data);
        }
        if (toType instanceof Class && (toClz = (Class)toType).isAnonymousClass()) {
            toType = toClz.getGenericSuperclass();
        }
        TypeReferenceImpl typeRef = new TypeReferenceImpl(toType);
        return this.getDeserializeConfig().getMapper().readValue(data, typeRef);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        this.init();
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        this.init();
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return this.getDeserializeConfig().getMapper().readTree(data);
        }
        return null;
    }

    public <T> void addEncoder(Class<T> clz, ValueSerializer<T> encoder) {
        this.getSerializeConfig().getCustomModule().addSerializer(clz, encoder);
    }

    public <T> void addEncoder(final Class<T> clz, final Converter<T, Object> converter) {
        if (clz == Date.class) {
            this.addEncoder((Class<T>)Date.class, (ValueSerializer<T>)new JavaUtilDateSerializer(){

                public void serialize(Date date, JsonGenerator out, SerializationContext sp) throws JacksonException {
                    if (this._customFormat == null) {
                        Jackson3StringSerializer.writeDefaultValue(converter, clz.cast(date), out);
                    } else {
                        super.serialize(date, out, sp);
                    }
                }
            });
        } else {
            this.addEncoder(clz, new ValueSerializer<T>(){

                public void serialize(T source, JsonGenerator out, SerializationContext sp) throws JacksonException {
                    Jackson3StringSerializer.writeDefaultValue(converter, source, out);
                }
            });
        }
    }

    private static <T> void writeDefaultValue(Converter<T, Object> converter, T source, JsonGenerator out) throws JacksonException {
        Object val = converter.convert(source);
        if (val == null) {
            out.writeNull();
        } else if (val instanceof String) {
            out.writeString((String)val);
        } else if (val instanceof Number) {
            if (val instanceof Integer || val instanceof Long) {
                out.writeNumber(((Number)val).longValue());
            } else {
                out.writeNumber(((Number)val).doubleValue());
            }
        } else {
            throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
        }
    }

    protected void loadJsonProps(JsonProps jsonProps) {
        boolean writeNulls = false;
        ObjectMapper mapper = this.getSerializeConfig().getMapper();
        MapperBuilder builder = mapper.rebuild();
        if (jsonProps != null) {
            JsonPropsUtil2.dateAsFormat((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.dateAsTicks((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.boolAsInt((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.longAsString((EntityStringSerializer)this, (JsonProps)jsonProps);
            boolean bl = writeNulls = jsonProps.nullAsWriteable || jsonProps.nullNumberAsZero || jsonProps.nullArrayAsEmpty || jsonProps.nullBoolAsFalse || jsonProps.nullStringAsEmpty;
            if (writeNulls) {
                builder.serializerFactory().withNullValueSerializer((ValueSerializer)new NullValueSerializerImpl(jsonProps));
            }
            if (jsonProps.enumAsName) {
                builder.configure((DatatypeFeature)EnumFeature.WRITE_ENUMS_USING_TO_STRING, true);
            }
        }
        if (!writeNulls) {
            builder.changeDefaultPropertyInclusion(v -> JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.USE_DEFAULTS));
        }
        builder.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        builder.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        builder.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        builder.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        builder.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        builder.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        ObjectMapper customMapper = builder.build();
        customMapper.serializationConfig().with((FormatFeature)JsonReadFeature.ALLOW_UNQUOTED_PROPERTY_NAMES);
        customMapper.serializationConfig().with((FormatFeature)JsonReadFeature.ALLOW_SINGLE_QUOTES);
        this.getSerializeConfig().setMapper(customMapper);
    }
}

