/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.serialization.ContextSerializer;
import org.noear.solon.serialization.jackson.impl.TypeReferenceImpl;

public class JacksonStringSerializer
implements ContextSerializer<String> {
    private static final String label = "/json";
    private ObjectMapper config;
    private Set<SerializationFeature> configFeatures;
    private SimpleModule configModule;
    private AtomicBoolean initStatus = new AtomicBoolean(false);

    public Set<SerializationFeature> getCustomFeatures() {
        if (this.configFeatures == null) {
            this.configFeatures = new HashSet<SerializationFeature>();
        }
        return this.configFeatures;
    }

    public SimpleModule getCustomModule() {
        if (this.configModule == null) {
            this.configModule = new SimpleModule();
        }
        return this.configModule;
    }

    public ObjectMapper getConfig() {
        if (this.config == null) {
            this.config = new ObjectMapper();
        }
        return this.config;
    }

    public void setConfig(ObjectMapper config) {
        if (config != null) {
            this.config = config;
        }
    }

    protected void init() {
        if (this.initStatus.compareAndSet(false, true)) {
            if (this.configFeatures != null) {
                for (SerializationFeature f1 : this.configFeatures) {
                    this.getConfig().enable(f1);
                }
            }
            if (this.configModule != null) {
                this.getConfig().registerModule((Module)this.configModule);
            }
        }
    }

    public String contentType() {
        return "application/json";
    }

    public Class<String> type() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label);
    }

    public String name() {
        return "jackson-json";
    }

    public String serialize(Object obj) throws IOException {
        this.init();
        return this.getConfig().writeValueAsString(obj);
    }

    public Object deserialize(String data, Type toType) throws IOException {
        Class toClz;
        this.init();
        if (toType == null) {
            return this.getConfig().readTree(data);
        }
        if (toType instanceof Class && (toClz = (Class)toType).isAnonymousClass()) {
            toType = toClz.getGenericSuperclass();
        }
        TypeReferenceImpl typeRef = new TypeReferenceImpl(toType);
        return this.getConfig().readValue(data, typeRef);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        this.init();
        ctx.contentType(this.contentType());
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx) throws IOException {
        this.init();
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return this.getConfig().readTree(data);
        }
        return null;
    }
}

