/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.hessian;

import com.alibaba.com.caucho.hessian.io.ClassFactory;
import com.alibaba.com.caucho.hessian.io.Hessian2Input;
import com.alibaba.com.caucho.hessian.io.Hessian2Output;
import com.alibaba.com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.EntitySerializer;

public class HessianBytesSerializer
implements EntitySerializer<byte[]> {
    private static final String label = "application/hessian";
    private static final HessianBytesSerializer _default = new HessianBytesSerializer();
    private static volatile SerializerFactory serializerFactory = HessianBytesSerializer.initDefaultSerializerFactory();

    public static HessianBytesSerializer getDefault() {
        return _default;
    }

    @Deprecated
    public static HessianBytesSerializer getInstance() {
        return _default;
    }

    public String mimeType() {
        return label;
    }

    public Class<byte[]> dataType() {
        return byte[].class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.startsWith(label);
    }

    public String name() {
        return "hessian-bytes";
    }

    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Hessian2Output ho = new Hessian2Output((OutputStream)out);
        ho.writeObject(obj);
        ho.close();
        return out.toByteArray();
    }

    public Object deserialize(byte[] data, Type toType) throws IOException {
        Hessian2Input hi = new Hessian2Input((InputStream)new ByteArrayInputStream(data));
        hi.setSerializerFactory(serializerFactory);
        return hi.readObject();
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        Hessian2Output ho = new Hessian2Output(ctx.outputStream());
        if (data instanceof ModelAndView) {
            ho.writeObject((Object)((ModelAndView)data).model());
        } else {
            ho.writeObject(data);
        }
        ho.flush();
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        Hessian2Input hi = new Hessian2Input(ctx.bodyAsStream());
        hi.setSerializerFactory(serializerFactory);
        return hi.readObject();
    }

    private static SerializerFactory initDefaultSerializerFactory() {
        SerializerFactory defaultSerializerFactory = new SerializerFactory();
        ClassFactory classFactory = defaultSerializerFactory.getClassFactory();
        classFactory.setWhitelist(false);
        classFactory.deny("org.apache.catalina.tribes.*");
        classFactory.deny("com.alibaba.citrus.springext.*");
        classFactory.deny("com.alipay.custrelation.*");
        classFactory.deny("com.alibaba.druid.*");
        return defaultSerializerFactory;
    }
}

