/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.noear.solon.Utils;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.EntityStringSerializer;
import org.noear.solon.serialization.gson.GsonDecl;
import org.noear.solon.serialization.gson.impl.DateSerialize;
import org.noear.solon.serialization.gson.impl.EnumWriteAdapter;
import org.noear.solon.serialization.gson.impl.NullArraySerialize;
import org.noear.solon.serialization.gson.impl.NullBooleanWriteAdapter;
import org.noear.solon.serialization.gson.impl.NullCollectionSerialize;
import org.noear.solon.serialization.gson.impl.NullLongWriteAdapter;
import org.noear.solon.serialization.gson.impl.NullNumberWriteAdapter;
import org.noear.solon.serialization.gson.impl.NullStringWriteAdapter;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil2;

public class GsonStringSerializer
implements EntityStringSerializer {
    private static final String label = "/json";
    private static final GsonStringSerializer _default = new GsonStringSerializer();
    private GsonDecl serializeConfig;
    private GsonDecl deserializeConfig;

    public static GsonStringSerializer getDefault() {
        return _default;
    }

    public GsonStringSerializer(JsonProps jsonProps) {
        this.loadJsonProps(jsonProps);
    }

    public GsonStringSerializer() {
    }

    public GsonDecl getSerializeConfig() {
        if (this.serializeConfig == null) {
            this.serializeConfig = new GsonDecl();
        }
        return this.serializeConfig;
    }

    public GsonDecl getDeserializeConfig() {
        if (this.deserializeConfig == null) {
            this.deserializeConfig = new GsonDecl();
        }
        return this.deserializeConfig;
    }

    public void refresh() {
        if (this.serializeConfig != null) {
            this.serializeConfig.refresh(true);
        }
        if (this.deserializeConfig != null) {
            this.deserializeConfig.refresh(true);
        }
    }

    public String mimeType() {
        return "application/json";
    }

    public Class<String> dataType() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label) || mime.startsWith("application/x-ndjson");
    }

    public String name() {
        return "gson-json";
    }

    public String serialize(Object obj) throws IOException {
        return this.getSerializeConfig().getGson().toJson(obj);
    }

    public Object deserialize(String data, Type toType) throws IOException {
        Class toClz;
        if (toType == null) {
            return JsonParser.parseString((String)data);
        }
        if (toType instanceof Class && (toClz = (Class)toType).isAnonymousClass()) {
            toType = toClz.getGenericSuperclass();
        }
        JsonElement jsonElement = JsonParser.parseString((String)data);
        return this.getDeserializeConfig().getGson().fromJson(jsonElement, toType);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return JsonParser.parseString((String)data);
        }
        return null;
    }

    public <T> T deserialize(JsonElement json, Type typeOfT) throws JsonSyntaxException {
        return (T)this.getDeserializeConfig().getGson().fromJson(json, typeOfT);
    }

    public <T> void addEncoder(Class<T> clz, JsonSerializer<T> encoder) {
        this.getSerializeConfig().getBuilder().registerTypeAdapter(clz, encoder);
    }

    public <T> void addEncoder(Class<T> clz, Converter<T, Object> converter) {
        this.addEncoder(clz, (source, type, jsc) -> {
            Object val = converter.convert(source);
            if (val == null) {
                return JsonNull.INSTANCE;
            }
            if (val instanceof String) {
                return new JsonPrimitive((String)val);
            }
            if (val instanceof Number) {
                return new JsonPrimitive((Number)val);
            }
            throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
        });
    }

    protected void loadJsonProps(JsonProps jsonProps) {
        boolean writeNulls = false;
        if (jsonProps != null) {
            JsonPropsUtil2.dateAsFormat((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.dateAsTicks((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.boolAsInt((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.longAsString((EntityStringSerializer)this, (JsonProps)jsonProps);
            boolean bl = writeNulls = jsonProps.nullAsWriteable || jsonProps.nullNumberAsZero || jsonProps.nullArrayAsEmpty || jsonProps.nullBoolAsFalse || jsonProps.nullStringAsEmpty;
            if (writeNulls) {
                this.getSerializeConfig().getBuilder().serializeNulls();
            }
            if (jsonProps.nullNumberAsZero) {
                this.getSerializeConfig().getBuilder().registerTypeAdapter(Short.class, new NullNumberWriteAdapter());
                this.getSerializeConfig().getBuilder().registerTypeAdapter(Integer.class, new NullNumberWriteAdapter());
                this.getSerializeConfig().getBuilder().registerTypeAdapter(Long.class, (Object)new NullLongWriteAdapter(jsonProps));
                this.getSerializeConfig().getBuilder().registerTypeAdapter(Float.class, new NullNumberWriteAdapter());
                this.getSerializeConfig().getBuilder().registerTypeAdapter(Double.class, new NullNumberWriteAdapter());
            }
            if (jsonProps.nullArrayAsEmpty) {
                this.getSerializeConfig().getBuilder().registerTypeAdapter(Collection.class, (Object)new NullCollectionSerialize());
                this.getSerializeConfig().getBuilder().registerTypeAdapter(Arrays.class, (Object)new NullArraySerialize());
            }
            if (jsonProps.nullBoolAsFalse) {
                this.getSerializeConfig().getBuilder().registerTypeAdapter(Boolean.class, (Object)new NullBooleanWriteAdapter(jsonProps));
            }
            if (jsonProps.nullStringAsEmpty) {
                this.getSerializeConfig().getBuilder().registerTypeAdapter(String.class, (Object)new NullStringWriteAdapter());
            }
            if (jsonProps.enumAsName) {
                this.getSerializeConfig().getBuilder().registerTypeAdapter(Enum.class, (Object)new EnumWriteAdapter());
            }
        } else {
            this.getSerializeConfig().getBuilder().registerTypeAdapter(Date.class, (Object)new DateSerialize());
        }
    }
}

