/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.gson;

import com.google.gson.JsonSerializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.noear.solon.core.handle.Render;
import org.noear.solon.serialization.ContextSerializer;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.StringSerializerRender;
import org.noear.solon.serialization.gson.GsonDateSerialize;
import org.noear.solon.serialization.gson.GsonRenderFactoryBase;
import org.noear.solon.serialization.gson.impl.EnumAdapter;
import org.noear.solon.serialization.gson.impl.NullArraySerialize;
import org.noear.solon.serialization.gson.impl.NullBooleanAdapter;
import org.noear.solon.serialization.gson.impl.NullCollectionSerialize;
import org.noear.solon.serialization.gson.impl.NullLongAdapter;
import org.noear.solon.serialization.gson.impl.NullNumberSerialize;
import org.noear.solon.serialization.gson.impl.NullStringSerialize;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;

public class GsonRenderFactory
extends GsonRenderFactoryBase {
    public GsonRenderFactory(JsonProps jsonProps) {
        this.applyProps(jsonProps);
    }

    @Override
    public <T> void addEncoder(Class<T> clz, JsonSerializer<T> encoder) {
        this.serializer.getConfig().registerTypeAdapter(clz, encoder);
    }

    public String[] mappings() {
        return new String[]{"@json"};
    }

    public Render create() {
        return new StringSerializerRender(false, (ContextSerializer)this.serializer);
    }

    protected void applyProps(JsonProps jsonProps) {
        boolean writeNulls = false;
        if (JsonPropsUtil.apply((JsonRenderFactory)this, (JsonProps)jsonProps)) {
            if (jsonProps.longAsString) {
                this.addConvertor(Long.class, String::valueOf);
                this.addConvertor(Long.TYPE, String::valueOf);
            }
            boolean bl = writeNulls = jsonProps.nullAsWriteable || jsonProps.nullNumberAsZero || jsonProps.nullArrayAsEmpty || jsonProps.nullBoolAsFalse || jsonProps.nullStringAsEmpty;
            if (writeNulls) {
                this.config().serializeNulls();
            }
            if (jsonProps.nullNumberAsZero) {
                this.config().registerTypeAdapter(Short.class, new NullNumberSerialize());
                this.config().registerTypeAdapter(Integer.class, new NullNumberSerialize());
                this.config().registerTypeAdapter(Long.class, (Object)new NullLongAdapter(jsonProps));
                this.config().registerTypeAdapter(Float.class, new NullNumberSerialize());
                this.config().registerTypeAdapter(Double.class, new NullNumberSerialize());
            }
            if (jsonProps.nullArrayAsEmpty) {
                this.config().registerTypeAdapter(Collection.class, (Object)new NullCollectionSerialize());
                this.config().registerTypeAdapter(Arrays.class, (Object)new NullArraySerialize());
            }
            if (jsonProps.nullBoolAsFalse) {
                this.config().registerTypeAdapter(Boolean.class, (Object)new NullBooleanAdapter(jsonProps));
            }
            if (jsonProps.nullStringAsEmpty) {
                this.config().registerTypeAdapter(String.class, (Object)new NullStringSerialize());
            }
            if (jsonProps.enumAsName) {
                this.config().registerTypeAdapter(Enum.class, (Object)new EnumAdapter());
            }
        } else {
            this.config().registerTypeAdapter(Date.class, (Object)new GsonDateSerialize());
        }
    }
}

