/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.ContextSerializer;

public class FastjsonStringSerializer
implements ContextSerializer<String> {
    private static final String label = "/json";
    private SerializeConfig serializeConfig;
    private int serializerFeatures = JSON.DEFAULT_GENERATE_FEATURE;
    private ParserConfig deserializeConfig;
    private int deserializeFeatures = JSON.DEFAULT_PARSER_FEATURE;

    public SerializeConfig getSerializeConfig() {
        if (this.serializeConfig == null) {
            this.serializeConfig = new SerializeConfig();
        }
        return this.serializeConfig;
    }

    public void cfgSerializerFeatures(boolean isReset, boolean isAdd, SerializerFeature ... features) {
        if (isReset) {
            this.serializerFeatures = JSON.DEFAULT_GENERATE_FEATURE;
        }
        for (SerializerFeature feature : features) {
            if (isAdd) {
                this.serializerFeatures |= feature.getMask();
                continue;
            }
            this.serializerFeatures &= ~feature.getMask();
        }
    }

    public ParserConfig getDeserializeConfig() {
        if (this.deserializeConfig == null) {
            this.deserializeConfig = new ParserConfig();
        }
        return this.deserializeConfig;
    }

    public void cfgDeserializeFeatures(boolean isReset, boolean isAdd, Feature ... features) {
        if (isReset) {
            this.deserializeFeatures = JSON.DEFAULT_GENERATE_FEATURE;
        }
        for (Feature feature : features) {
            if (isAdd) {
                this.deserializeFeatures |= feature.getMask();
                continue;
            }
            this.deserializeFeatures &= ~feature.getMask();
        }
    }

    public String mimeType() {
        return "application/json";
    }

    public Class<String> dataType() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label) || mime.startsWith("application/x-ndjson");
    }

    public String name() {
        return "fastjson-json";
    }

    public String serialize(Object obj) throws IOException {
        if (this.serializeConfig == null) {
            return JSON.toJSONString((Object)obj, (int)this.serializerFeatures, (SerializerFeature[])new SerializerFeature[0]);
        }
        return JSON.toJSONString((Object)obj, (SerializeConfig)this.serializeConfig, (SerializeFilter[])new SerializeFilter[0], null, (int)this.serializerFeatures, (SerializerFeature[])new SerializerFeature[0]);
    }

    public Object deserialize(String data, Type toType) throws IOException {
        Class toClz;
        if (toType == null) {
            if (this.deserializeConfig == null) {
                return JSON.parse((String)data, (int)this.deserializeFeatures);
            }
            return JSON.parse((String)data, (ParserConfig)this.deserializeConfig, (int)this.deserializeFeatures);
        }
        if (toType instanceof Class && (toClz = (Class)toType).isAnonymousClass()) {
            toType = toClz.getGenericSuperclass();
        }
        if (this.deserializeConfig == null) {
            return JSON.parseObject((String)data, (Type)toType, (int)this.deserializeFeatures, (Feature[])new Feature[0]);
        }
        return JSON.parseObject((String)data, (Type)toType, (ParserConfig)this.deserializeConfig, (int)this.deserializeFeatures, (Feature[])new Feature[0]);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        ctx.contentType(this.mimeType());
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            if (this.deserializeConfig == null) {
                return JSON.parse((String)data, (int)this.deserializeFeatures);
            }
            return JSON.parse((String)data, (ParserConfig)this.deserializeConfig, (int)this.deserializeFeatures);
        }
        return null;
    }
}

