/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.sbe.solon;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.solon.SbeSerializable;

public class SbeOutput {
    private final MutableDirectBuffer buffer;
    private int currentOffset = 0;

    public SbeOutput(MutableDirectBuffer buffer) {
        this.buffer = buffer;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[this.buffer.capacity()];
        this.buffer.getBytes(0, bytes);
        return bytes;
    }

    public void writeInt(int intValue) {
        this.buffer.putInt(this.currentOffset, intValue);
        this.currentOffset += 4;
    }

    public void writeLong(long longValue) {
        this.buffer.putLong(this.currentOffset, longValue);
        this.currentOffset += 8;
    }

    public void writeFloat(float floatValue) {
        this.buffer.putFloat(this.currentOffset, floatValue);
        this.currentOffset += 4;
    }

    public void writeDouble(double doubleValue) {
        this.buffer.putDouble(this.currentOffset, doubleValue);
        this.currentOffset += 8;
    }

    public void writeByte(byte byteValue) {
        this.buffer.putByte(this.currentOffset, byteValue);
        ++this.currentOffset;
    }

    public void writeChar(char charValue) {
        this.buffer.putChar(this.currentOffset, charValue);
        this.currentOffset += 2;
    }

    public void writeBoolean(boolean booleanValue) {
        this.buffer.putByte(this.currentOffset, (byte)(booleanValue ? 1 : 0));
        ++this.currentOffset;
    }

    public void writeShort(short shortValue) {
        this.buffer.putShort(this.currentOffset, shortValue);
        this.currentOffset += 2;
    }

    public void writeString(String stringValue) {
        this.writeByteArray(stringValue.getBytes());
    }

    public void writeBigInteger(BigInteger bigInteger) {
        this.writeByteArray(bigInteger.toByteArray());
    }

    public void writeBigDecimal(BigDecimal bigDecimal) {
        this.writeString(bigDecimal.toString());
    }

    public void writeIntArray(int[] ints) {
        this.writeInt(ints.length);
        for (int i = 0; i < ints.length; ++i) {
            this.writeInt(ints[i]);
        }
    }

    public void writeLongArray(long[] longs) {
        this.writeInt(longs.length);
        for (int i = 0; i < longs.length; ++i) {
            this.writeLong(longs[i]);
        }
    }

    public void writeFloatArray(float[] floats) {
        this.writeFloat(floats.length);
        for (int i = 0; i < floats.length; ++i) {
            this.writeFloat(floats[i]);
        }
    }

    public void writeDoubleArray(double[] doubles) {
        this.writeInt(doubles.length);
        for (int i = 0; i < doubles.length; ++i) {
            this.writeDouble(doubles[i]);
        }
    }

    public void writeShortArray(short[] shorts) {
        this.writeInt(shorts.length);
        for (int i = 0; i < shorts.length; ++i) {
            this.writeShort(shorts[i]);
        }
    }

    public void writeByteArray(byte[] bytes) {
        this.writeInt(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            this.writeByte(bytes[i]);
        }
    }

    public void writeCharArray(char[] chars) {
        this.writeInt(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            this.writeChar(chars[i]);
        }
    }

    public <T extends SbeSerializable> void writeObject(T object) {
        this.writeBoolean(object != null);
        if (object != null) {
            object.serializeWrite((SbeOutput)this);
        }
    }

    public <T extends SbeSerializable> void writeArray(T[] array) {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            array[i].serializeWrite((SbeOutput)this);
        }
    }

    public <T extends SbeSerializable> void writeList(List<SbeSerializable> collection) {
        int size = collection.size();
        this.writeInt(size);
        collection.forEach(e -> e.serializeWrite(this));
    }

    public <T> void writeNullable(T object, BiConsumer<T, SbeOutput> marshaller) {
        this.writeBoolean(object != null);
        if (object != null) {
            marshaller.accept(object, this);
        }
    }

    public <K, V> void writeMap(Map<K, V> map, BiConsumer<SbeOutput, K> keyMarshaller, BiConsumer<SbeOutput, V> valMarshaller) {
        int size = map.size();
        this.writeInt(size);
        map.forEach((k, v) -> {
            keyMarshaller.accept(this, k);
            valMarshaller.accept(this, v);
        });
    }

    public void reset() {
        this.currentOffset = 0;
    }
}

