/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.command;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.scheduling.command.CommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandManager {
    private static final Logger log = LoggerFactory.getLogger(CommandManager.class);
    private Map<String, CommandExecutor> executorMap = new LinkedHashMap<String, CommandExecutor>();

    public static CommandManager getInstance() {
        return (CommandManager)Solon.context().attachOf(CommandManager.class, CommandManager::new);
    }

    public void register(String command, CommandExecutor executor) {
        this.executorMap.put(command, executor);
    }

    public boolean exists(String command) {
        return this.executorMap.containsKey(command);
    }

    public void execute(String command) throws Throwable {
        CommandExecutor executor = this.executorMap.get(command);
        if (executor != null) {
            executor.execute(command);
        }
    }

    public void executeAll() {
        CommandExecutor def = this.executorMap.get("");
        if (def != null) {
            this.executeDo("", def);
        }
        for (Map.Entry<String, CommandExecutor> kv : this.executorMap.entrySet()) {
            if (!Solon.cfg().argx().containsKey((Object)kv.getKey())) continue;
            this.executeDo(kv.getKey(), kv.getValue());
        }
    }

    private void executeDo(String cmd, CommandExecutor executor) {
        try {
            executor.execute(cmd);
        }
        catch (Throwable e) {
            log.warn("Command execute failed, cmd={}", (Object)cmd, (Object)e);
        }
    }
}

