/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.utils;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.Props;
import org.noear.solon.scheduling.ScheduledAnno;

public class ScheduledHelper {
    public static void resetScheduled(ScheduledAnno warpper) {
        if (warpper.cron().length() < 6 || warpper.cron().indexOf(" ") < 0) {
            warpper.fixedRate(ScheduledHelper.fixedRate(warpper.cron()));
            warpper.cron("");
        } else {
            warpper.fixedRate(0L);
        }
    }

    public static void configScheduled(ScheduledAnno warpper) {
        Props prop;
        if (warpper.cron().length() < 6 || warpper.cron().indexOf(" ") < 0) {
            if (warpper.fixedRate() == 0L) {
                warpper.fixedRate(ScheduledHelper.fixedRate(warpper.cron()));
            }
            warpper.cron("");
        }
        if (Utils.isNotEmpty((String)warpper.name()) && (prop = Solon.cfg().getProp("solon.scheduling.job." + warpper.name())).size() > 0) {
            String enableStr = prop.getProperty("enable");
            String cronStr = prop.getProperty("cron");
            String zoneStr = prop.getProperty("zone");
            String fixedRateStr = prop.getProperty("fixedRate");
            String fixedDelayStr = prop.getProperty("fixedDelay");
            String initialDelayStr = prop.getProperty("initialDelay");
            if ("false".equals(enableStr)) {
                warpper.enable(false);
            }
            if (Utils.isNotEmpty((String)cronStr)) {
                if (cronStr.length() > 6 && cronStr.contains(" ")) {
                    warpper.cron(cronStr);
                } else {
                    warpper.fixedRate(ScheduledHelper.fixedRate(cronStr));
                }
            }
            if (Utils.isNotEmpty((String)zoneStr)) {
                warpper.zone(zoneStr);
            }
            if (Utils.isNotEmpty((String)fixedRateStr)) {
                warpper.fixedRate(Long.parseLong(fixedRateStr));
            }
            if (Utils.isNotEmpty((String)fixedDelayStr)) {
                warpper.fixedDelay(Long.parseLong(fixedDelayStr));
            }
            if (Utils.isNotEmpty((String)initialDelayStr)) {
                warpper.initialDelay(Long.parseLong(initialDelayStr));
            }
        }
    }

    public static long fixedRate(String cronx) {
        if (cronx.endsWith("ms")) {
            long period = Long.parseLong(cronx.substring(0, cronx.length() - 2));
            return period;
        }
        if (cronx.endsWith("s")) {
            long period = Long.parseLong(cronx.substring(0, cronx.length() - 1));
            return period * 1000L;
        }
        if (cronx.endsWith("m")) {
            long period = Long.parseLong(cronx.substring(0, cronx.length() - 1));
            return period * 1000L * 60L;
        }
        if (cronx.endsWith("h")) {
            long period = Long.parseLong(cronx.substring(0, cronx.length() - 1));
            return period * 1000L * 60L * 60L;
        }
        if (cronx.endsWith("d")) {
            long period = Long.parseLong(cronx.substring(0, cronx.length() - 1));
            return period * 1000L * 60L * 60L * 24L;
        }
        return 0L;
    }
}

