/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.async;

import java.util.concurrent.Future;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.scheduling.annotation.Async;
import org.noear.solon.scheduling.async.AsyncExecutor;
import org.noear.solon.scheduling.async.AsyncExecutorDefault;

public class AsyncInterceptor
implements Interceptor {
    private AsyncExecutor asyncExecutor = new AsyncExecutorDefault();

    public AsyncInterceptor(AppContext context) {
        context.getBeanAsync(AsyncExecutor.class, bean -> {
            this.asyncExecutor = bean;
        });
    }

    public Object doIntercept(Invocation inv) throws Throwable {
        Async anno = (Async)inv.getMethodAnnotation(Async.class);
        if (anno != null) {
            Future future = this.asyncExecutor.submit(inv, anno);
            if (inv.method().getReturnType().isAssignableFrom(Future.class)) {
                return future;
            }
            return null;
        }
        return inv.invoke();
    }
}

