/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.quartz;

import java.time.ZoneId;
import java.util.TimeZone;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.Lifecycle;
import org.noear.solon.scheduling.quartz.QuartzProxy;
import org.noear.solon.scheduling.scheduled.JobHolder;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzSchedulerProxy
implements Lifecycle {
    private Scheduler _scheduler = null;

    public void start() throws Throwable {
        this.tryInitScheduler();
        this._scheduler.start();
    }

    public void stop() throws Throwable {
        if (this._scheduler != null) {
            this._scheduler.shutdown();
            this._scheduler = null;
        }
    }

    private JobKey getJobKey(String name) {
        String jobGroup = Utils.annoAlias((String)Solon.cfg().appName(), (String)"solon");
        return JobKey.jobKey((String)name, (String)jobGroup);
    }

    public boolean exists(String name) throws SchedulerException {
        if (this._scheduler != null) {
            return this._scheduler.checkExists(this.getJobKey(name));
        }
        return false;
    }

    public void remove(String name) throws SchedulerException {
        if (this._scheduler != null) {
            this._scheduler.deleteJob(this.getJobKey(name));
        }
    }

    public void pause(String name) throws SchedulerException {
        if (this._scheduler != null) {
            this._scheduler.pauseJob(this.getJobKey(name));
        }
    }

    public void resume(String name) throws SchedulerException {
        if (this._scheduler != null) {
            this._scheduler.resumeJob(this.getJobKey(name));
        }
    }

    public void register(JobHolder jobHolder) throws SchedulerException {
        this.tryInitScheduler();
        String jobGroup = Utils.annoAlias((String)Solon.cfg().appName(), (String)"solon");
        if (Utils.isEmpty((String)jobHolder.getScheduled().cron())) {
            this.regJobByFixedRate(jobHolder, jobHolder.getScheduled().fixedRate(), jobGroup);
        } else {
            this.regJobByCron(jobHolder, jobHolder.getScheduled().cron(), jobHolder.getScheduled().zone(), jobGroup);
        }
    }

    private void regJobByCron(JobHolder jobHolder, String cron, String zone, String jobGroup) throws SchedulerException {
        this.tryInitScheduler();
        JobDetail jobDetail = JobBuilder.newJob(QuartzProxy.class).withIdentity(jobHolder.getName(), jobGroup).build();
        if (!this._scheduler.checkExists(jobDetail.getKey())) {
            CronScheduleBuilder builder = CronScheduleBuilder.cronSchedule((String)cron);
            if (Utils.isNotEmpty((String)zone)) {
                builder.inTimeZone(TimeZone.getTimeZone(ZoneId.of(zone)));
            }
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobHolder.getName(), jobGroup).startNow().withSchedule((ScheduleBuilder)builder).build();
            this._scheduler.scheduleJob(jobDetail, trigger);
        }
    }

    private void regJobByFixedRate(JobHolder jobHolder, long milliseconds, String jobGroup) throws SchedulerException {
        this.tryInitScheduler();
        JobDetail jobDetail = JobBuilder.newJob(QuartzProxy.class).withIdentity(jobHolder.getName(), jobGroup).build();
        if (!this._scheduler.checkExists(jobDetail.getKey())) {
            SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule();
            builder.withIntervalInMilliseconds(milliseconds);
            builder.repeatForever();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobHolder.getName(), jobGroup).startNow().withSchedule((ScheduleBuilder)builder).build();
            this._scheduler.scheduleJob(jobDetail, trigger);
        }
    }

    public void setScheduler(Scheduler scheduler) {
        if (this._scheduler == null) {
            this._scheduler = scheduler;
        }
    }

    private void tryInitScheduler() throws SchedulerException {
        if (this._scheduler == null) {
            Utils.locker().lock();
            try {
                if (this._scheduler == null) {
                    StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
                    this._scheduler = schedulerFactory.getScheduler();
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
    }
}

