/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.quartz.integration;

import java.lang.reflect.Method;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.Lifecycle;
import org.noear.solon.core.Plugin;
import org.noear.solon.scheduling.annotation.EnableScheduling;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.noear.solon.scheduling.quartz.JobManager;
import org.noear.solon.scheduling.scheduled.manager.IJobManager;
import org.noear.solon.scheduling.scheduled.manager.JobExtractor;
import org.quartz.Job;
import org.quartz.Scheduler;

public class SchedulingQuartzPlugin
implements Plugin {
    public void start(AppContext context) {
        if (context.app().source().getAnnotation(EnableScheduling.class) == null) {
            return;
        }
        context.wrapAndPut(IJobManager.class, (Object)JobManager.getInstance());
        context.getBeanAsync(Scheduler.class, bean -> JobManager.getInstance().setScheduler((Scheduler)bean));
        JobExtractor jobExtractor = new JobExtractor((IJobManager)JobManager.getInstance());
        context.beanBuilderAdd(Scheduled.class, (BeanBuilder)jobExtractor);
        context.beanBuilderAdd(Scheduled.class, Job.class, (clz, bw, anno) -> {
            Method method = Job.class.getDeclaredMethods()[0];
            jobExtractor.doExtract(bw, method, anno);
        });
        context.beanExtractorAdd(Scheduled.class, (BeanExtractor)jobExtractor);
        context.lifecycle(Integer.MAX_VALUE, (Lifecycle)JobManager.getInstance());
    }
}

