/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.quartz;

import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.scheduling.ScheduledException;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.noear.solon.scheduling.quartz.QuartzSchedulerProxy;
import org.noear.solon.scheduling.scheduled.JobHolder;
import org.noear.solon.scheduling.scheduled.manager.AbstractJobManager;
import org.quartz.Scheduler;

public class JobManager
extends AbstractJobManager {
    private static JobManager instance = new JobManager();
    private QuartzSchedulerProxy schedulerProxy = new QuartzSchedulerProxy();

    public static JobManager getInstance() {
        return instance;
    }

    public void setScheduler(Scheduler real) {
        this.schedulerProxy.setScheduler(real);
    }

    public void jobStart(String name, Map<String, String> data) throws ScheduledException {
        JobHolder holder = this.jobGet(name);
        if (holder != null) {
            holder.setData(data);
            try {
                if (this.schedulerProxy.exists(name)) {
                    this.schedulerProxy.resume(name);
                } else {
                    this.schedulerProxy.register(holder);
                }
            }
            catch (Exception e) {
                throw new ScheduledException((Throwable)e);
            }
        }
    }

    public void jobStop(String name) throws ScheduledException {
        if (this.jobExists(name)) {
            try {
                this.schedulerProxy.pause(name);
            }
            catch (Exception e) {
                throw new ScheduledException((Throwable)e);
            }
        }
    }

    public void jobRemove(String name) throws ScheduledException {
        if (this.jobExists(name)) {
            super.jobRemove(name);
            try {
                this.schedulerProxy.remove(name);
            }
            catch (Exception e) {
                throw new ScheduledException((Throwable)e);
            }
        }
    }

    protected void jobAddCheckDo(String name, Scheduled scheduled) {
        if (Utils.isEmpty((String)name)) {
            throw new IllegalArgumentException("The job name cannot be empty!");
        }
        if (scheduled.fixedRate() > 0L && Utils.isNotEmpty((String)scheduled.cron())) {
            throw new IllegalArgumentException("The job cron and fixedRate cannot both have values: " + name);
        }
        if (scheduled.initialDelay() > 0L) {
            throw new IllegalArgumentException("The job unsupported initialDelay!");
        }
        if (scheduled.fixedDelay() > 0L) {
            throw new IllegalArgumentException("The job unsupported fixedDelay!");
        }
    }

    public void start() throws Throwable {
        for (JobHolder holder : this.jobMap.values()) {
            if (!holder.getScheduled().enable()) continue;
            this.schedulerProxy.register(holder);
        }
        this.schedulerProxy.start();
        this.isStarted = true;
    }

    public void stop() throws Throwable {
        this.isStarted = false;
        if (this.schedulerProxy != null) {
            this.schedulerProxy.stop();
            this.schedulerProxy = null;
        }
    }
}

