/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.rx;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSubscriber<T>
implements Subscriber<T> {
    static final Logger log = LoggerFactory.getLogger(SimpleSubscriber.class);
    private Consumer<Subscription> doOnSubscribe;
    private Function<T, Boolean> doOnNextFunc;
    private Consumer<T> doOnNextCons;
    private Consumer<Throwable> doOnError;
    private Runnable doOnComplete;
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private Subscription subscription;

    public SimpleSubscriber<T> doOnSubscribe(Consumer<Subscription> doOnSubscribe) {
        this.doOnSubscribe = doOnSubscribe;
        return this;
    }

    public SimpleSubscriber<T> doOnNext(Function<T, Boolean> doOnNext) {
        this.doOnNextFunc = doOnNext;
        this.doOnNextCons = null;
        return this;
    }

    public SimpleSubscriber<T> doOnNext(Consumer<T> doOnNext) {
        this.doOnNextFunc = null;
        this.doOnNextCons = doOnNext;
        return this;
    }

    public SimpleSubscriber<T> doOnError(Consumer<Throwable> doOnError) {
        this.doOnError = doOnError;
        return this;
    }

    public SimpleSubscriber<T> doOnComplete(Runnable doOnComplete) {
        this.doOnComplete = doOnComplete;
        return this;
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public void cancel() {
        if (this.cancelled.compareAndSet(false, true) && this.subscription != null) {
            this.subscription.cancel();
        }
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        if (this.doOnSubscribe != null) {
            this.doOnSubscribe.accept(subscription);
        } else {
            subscription.request(Long.MAX_VALUE);
        }
    }

    public void onNext(T item) {
        if (this.terminated.get() || this.cancelled.get()) {
            return;
        }
        try {
            if (this.doOnNextFunc != null) {
                if (!this.doOnNextFunc.apply(item).booleanValue()) {
                    this.cancel();
                }
            } else if (this.doOnNextCons != null) {
                this.doOnNextCons.accept(item);
            }
        }
        catch (Throwable t) {
            this.onError(t);
        }
    }

    public void onError(Throwable err) {
        if (this.terminated.compareAndSet(false, true) && this.doOnError != null) {
            try {
                this.doOnError.accept(err);
            }
            catch (Throwable t) {
                log.warn("Error in doOnError callback", t);
            }
        }
    }

    public void onComplete() {
        if (this.terminated.compareAndSet(false, true) && this.doOnComplete != null) {
            try {
                this.doOnComplete.run();
            }
            catch (Throwable t) {
                log.warn("Error in doOnComplete callback", t);
            }
        }
    }
}

