/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.rx;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.rx.CompletableEmitter;
import org.noear.solon.rx.impl.CompletableImpl;
import org.reactivestreams.Publisher;

public interface Completable
extends Publisher<Void> {
    public Completable doOnError(Consumer<Throwable> var1);

    public Completable doOnErrorResume(Function<Throwable, Completable> var1);

    public Completable doOnComplete(Runnable var1);

    public static Completable create(Consumer<CompletableEmitter> emitterConsumer) {
        if (emitterConsumer == null) {
            throw new IllegalArgumentException("emitterConsumer cannot be null");
        }
        return new CompletableImpl(null, emitterConsumer);
    }

    public Completable then(Supplier<Completable> var1);

    default public Completable then(Completable other) {
        return this.then(() -> other);
    }

    default public Completable subscribeOn(Executor executor) {
        return Completable.create(emitter -> executor.execute(() -> this.subscribe((CompletableEmitter)emitter)));
    }

    default public Completable delay(long delay, TimeUnit unit) {
        return Completable.create(emitter -> RunUtil.delay(() -> this.subscribe((CompletableEmitter)emitter), (long)unit.toMillis(delay)));
    }

    public void subscribe();

    public void subscribe(CompletableEmitter var1);

    public static Completable complete() {
        return new CompletableImpl(null, null);
    }

    public static Completable error(Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException("cause cannot be null");
        }
        return new CompletableImpl(cause, null);
    }
}

