/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.rx;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SimpleSubscriber<T>
implements Subscriber<T> {
    private Consumer<Subscription> doOnSubscribe;
    private Function<T, Boolean> doOnNextFunc;
    private Consumer<T> doOnNextCons;
    private Consumer<Throwable> doOnError;
    private Runnable doOnComplete;
    private final AtomicBoolean isCompleted = new AtomicBoolean(false);
    private Subscription subscription;

    public SimpleSubscriber<T> doOnSubscribe(Consumer<Subscription> doOnSubscribe) {
        this.doOnSubscribe = doOnSubscribe;
        return this;
    }

    public SimpleSubscriber<T> doOnNext(Function<T, Boolean> doOnNext) {
        this.doOnNextFunc = doOnNext;
        this.doOnNextCons = null;
        return this;
    }

    public SimpleSubscriber<T> doOnNext(Consumer<T> doOnNext) {
        this.doOnNextFunc = null;
        this.doOnNextCons = doOnNext;
        return this;
    }

    public SimpleSubscriber<T> doOnError(Consumer<Throwable> doOnError) {
        this.doOnError = doOnError;
        return this;
    }

    public SimpleSubscriber<T> doOnComplete(Runnable doOnComplete) {
        this.doOnComplete = doOnComplete;
        return this;
    }

    public void cancel() {
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        if (this.doOnSubscribe != null) {
            this.doOnSubscribe.accept(subscription);
        } else {
            subscription.request(1L);
        }
    }

    public void onNext(T item) {
        if (this.doOnNextFunc != null) {
            if (!this.doOnNextFunc.apply(item).booleanValue()) {
                this.cancel();
            }
        } else if (this.doOnNextCons != null) {
            this.doOnNextCons.accept(item);
        }
        if (this.subscription != null) {
            this.subscription.request(1L);
        }
    }

    public void onError(Throwable throwable) {
        if (this.doOnError != null) {
            this.doOnError.accept(throwable);
        }
    }

    public void onComplete() {
        if (this.doOnComplete != null && this.isCompleted.compareAndSet(false, true)) {
            this.doOnComplete.run();
        }
    }
}

