/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.rx;

import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SimpleSubscriber<T>
implements Subscriber<T> {
    private Consumer<Subscription> doOnSubscribe;
    private Consumer<T> doOnNext;
    private Consumer<Throwable> doOnError;
    private Runnable doOnComplete;

    public SimpleSubscriber<T> doOnSubscribe(Consumer<Subscription> doOnSubscribe) {
        this.doOnSubscribe = doOnSubscribe;
        return this;
    }

    public SimpleSubscriber<T> doOnNext(Consumer<T> doOnNext) {
        this.doOnNext = doOnNext;
        return this;
    }

    public SimpleSubscriber<T> doOnError(Consumer<Throwable> doOnError) {
        this.doOnError = doOnError;
        return this;
    }

    public SimpleSubscriber<T> doOnComplete(Runnable doOnComplete) {
        this.doOnComplete = doOnComplete;
        return this;
    }

    public void onSubscribe(Subscription subscription) {
        if (this.doOnSubscribe != null) {
            this.doOnSubscribe.accept(subscription);
        } else {
            subscription.request(Long.MAX_VALUE);
        }
    }

    public void onNext(T item) {
        if (this.doOnNext != null) {
            this.doOnNext.accept(item);
        }
    }

    public void onError(Throwable throwable) {
        if (this.doOnError != null) {
            this.doOnError.accept(throwable);
        }
    }

    public void onComplete() {
        if (this.doOnComplete != null) {
            this.doOnComplete.run();
        }
    }
}

