/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.proxy.aot.AotProxy;
import org.noear.solon.proxy.asm.AsmProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(BeanInvocationHandler.class);
    private Class<?> clazz;
    private Object raw;
    private Constructor rawCon;
    private Object[] rawConArgs;
    private Object proxy;
    private InvocationHandler handler;
    private final AppContext context;

    public BeanInvocationHandler(AppContext context, InvocationHandler handler, Object raw, Constructor rawCon, Object[] rawConArgs) {
        this(context, handler, raw.getClass(), raw, rawCon, rawConArgs);
    }

    public BeanInvocationHandler(AppContext context, InvocationHandler handler, Class<?> clazz, Object raw, Constructor rawCon, Object[] rawConArgs) {
        this.context = context;
        this.handler = handler;
        this.clazz = clazz;
        this.raw = raw;
        this.rawCon = rawCon;
        this.rawConArgs = rawConArgs;
        if (NativeDetector.isNotAotRuntime()) {
            this.proxy = AotProxy.newProxyInstance(context, this, clazz, rawConArgs);
        }
        if (this.proxy == null) {
            this.proxy = AsmProxy.newProxyInstance(context, this, clazz, rawCon, rawConArgs);
        }
        if (Solon.cfg().isDebugMode() && this.proxy != null) {
            log.trace("Proxy class:" + this.proxy.getClass().getName());
        }
    }

    public Object getProxy() {
        return this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.handler == null) {
            method.setAccessible(true);
            Object result = this.context.methodGet(this.clazz, method).invokeByAspect(this.raw, args);
            return result;
        }
        return this.handler.invoke(this.raw, method, args);
    }
}

