/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.solon.integration;

import com.github.xiaoymin.knife4j.solon.extension.OpenApiExtensionResolver;
import com.github.xiaoymin.knife4j.solon.integration.Knife4jController;
import com.github.xiaoymin.knife4j.solon.settings.OpenApiSetting;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.docs.BasicAuth;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.web.staticfiles.StaticMappings;
import org.noear.solon.web.staticfiles.StaticRepository;
import org.noear.solon.web.staticfiles.repository.ClassPathStaticRepository;

public class Knife4jPlugin
implements Plugin {
    public void start(AppContext context) {
        OpenApiExtensionResolver openApiExtensionResolver = (OpenApiExtensionResolver)context.wrapAndPut(OpenApiExtensionResolver.class).get();
        OpenApiSetting setting = openApiExtensionResolver.getSetting();
        if (!setting.isEnable()) {
            return;
        }
        if (setting.isProduction() && !context.app().cfg().isFilesMode()) {
            return;
        }
        String uiPath = "/";
        StaticMappings.add((String)uiPath, (StaticRepository)new ClassPathStaticRepository("META-INF/resources"));
        context.app().router().add(uiPath, Knife4jController.class);
        context.subBeansOfType(DocDocket.class, bean -> {
            if (Utils.isEmpty((Map)bean.basicAuth())) {
                bean.basicAuth((BasicAuth)setting.getBasic());
            }
            bean.vendorExtensions(openApiExtensionResolver.buildExtensions());
        });
    }
}

