/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.integration;

import org.noear.socketd.transport.core.Listener;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.net.annotation.ServerEndpoint;
import org.noear.solon.net.socketd.SocketdRouter;
import org.noear.solon.net.websocket.WebSocketListener;
import org.noear.solon.net.websocket.WebSocketListenerSupplier;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.noear.solon.net.websocket.listener.ContextPathWebSocketListener;

public class NetPlugin
implements Plugin {
    private SocketdRouter socketdRouter;
    private WebSocketRouter webSocketRouter;

    public void start(AppContext context) throws Throwable {
        this.webSocketRouter = WebSocketRouter.getInstance();
        context.lifecycle(() -> {
            if (Utils.isNotEmpty((String)Solon.cfg().serverContextPath())) {
                this.webSocketRouter.beforeIfAbsent(new ContextPathWebSocketListener());
            }
        });
        if (ClassUtil.hasClass(() -> Listener.class)) {
            this.socketdRouter = SocketdRouter.getInstance();
        }
        context.beanBuilderAdd(ServerEndpoint.class, this::serverEndpointBuild);
    }

    private void serverEndpointBuild(Class<?> clz, BeanWrap bw, ServerEndpoint anno) {
        String path = Solon.cfg().getByTmpl(anno.value());
        boolean registered = false;
        if (bw.raw() instanceof WebSocketListenerSupplier) {
            if (Utils.isEmpty((String)path)) {
                path = "**";
            }
            WebSocketListenerSupplier supplier = (WebSocketListenerSupplier)bw.raw();
            this.webSocketRouter.of(path, supplier.getWebSocketListener());
            registered = true;
        } else if (bw.raw() instanceof WebSocketListener) {
            if (Utils.isEmpty((String)path)) {
                path = "**";
            }
            this.webSocketRouter.of(path, (WebSocketListener)bw.raw());
            registered = true;
        } else if (ClassUtil.hasClass(() -> Listener.class) && bw.raw() instanceof Listener) {
            if (Utils.isEmpty((String)path)) {
                path = "**";
            }
            this.socketdRouter.of(path, (Listener)bw.raw());
            registered = true;
        }
        if (!registered) {
            LogUtil.global().warn("@ServerEndpoint does not support type: " + clz.getName());
        }
    }
}

