/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.websocket.listener;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketListener;

public class PipelineWebSocketListener
implements WebSocketListener {
    protected final Deque<WebSocketListener> pipeline = new LinkedList<WebSocketListener>();
    protected final Set<Class<?>> typeSet = new HashSet();

    public PipelineWebSocketListener prev(WebSocketListener listener) {
        this.pipeline.addFirst(listener);
        return this;
    }

    public PipelineWebSocketListener prevIfAbsent(WebSocketListener listener) {
        if (!this.typeSet.contains(listener.getClass())) {
            this.typeSet.add(listener.getClass());
            this.pipeline.addFirst(listener);
        }
        return this;
    }

    public PipelineWebSocketListener next(WebSocketListener listener) {
        this.pipeline.addLast(listener);
        return this;
    }

    public PipelineWebSocketListener nextIfAbsent(WebSocketListener listener) {
        if (!this.typeSet.contains(listener.getClass())) {
            this.typeSet.add(listener.getClass());
            this.pipeline.addLast(listener);
        }
        return this;
    }

    @Override
    public void onOpen(WebSocket s) {
        for (WebSocketListener listener : this.pipeline) {
            listener.onOpen(s);
        }
    }

    @Override
    public void onMessage(WebSocket s, String text) throws IOException {
        for (WebSocketListener listener : this.pipeline) {
            listener.onMessage(s, text);
        }
    }

    @Override
    public void onMessage(WebSocket s, ByteBuffer binary) throws IOException {
        for (WebSocketListener listener : this.pipeline) {
            listener.onMessage(s, binary);
        }
    }

    @Override
    public void onClose(WebSocket s) {
        for (WebSocketListener listener : this.pipeline) {
            listener.onClose(s);
        }
    }

    @Override
    public void onError(WebSocket s, Throwable error) {
        for (WebSocketListener listener : this.pipeline) {
            listener.onError(s, error);
        }
    }

    @Override
    public void onPing(WebSocket s) {
        for (WebSocketListener listener : this.pipeline) {
            listener.onPing(s);
        }
    }

    @Override
    public void onPong(WebSocket s) {
        for (WebSocketListener listener : this.pipeline) {
            listener.onPong(s);
        }
    }
}

