/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.handle;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.Message;
import org.noear.solon.net.stomp.StompSession;
import org.noear.solon.net.stomp.broker.impl.StompBrokerMedia;
import org.noear.solon.net.stomp.handle.StompContext;
import org.noear.solon.net.stomp.listener.StompListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardStompListener
implements StompListener {
    static final Logger log = LoggerFactory.getLogger(ForwardStompListener.class);
    private final StompBrokerMedia brokerMedia;

    public ForwardStompListener(StompBrokerMedia brokerMedia) {
        this.brokerMedia = brokerMedia;
    }

    @Override
    public void onFrame(StompSession session, Frame frame) throws Throwable {
        if ("SEND".equals(frame.getCommand())) {
            this.onSend(session, frame);
        }
    }

    protected void onSend(StompSession session, Frame frame) throws Throwable {
        String destination = frame.getHeader("destination");
        if (Utils.isEmpty((String)destination)) {
            log.warn("This stomp message is missing route, source={}", (Object)frame.getSource());
            Frame frame1 = Frame.newBuilder().command("ERROR").payload("Required 'destination' header missed").build();
            session.send(frame1);
        } else {
            this.toBroker(session, destination, frame);
            this.toApp(session, destination, frame);
        }
    }

    protected void toBroker(StompSession session, String destination, Frame frame) throws Throwable {
        if (this.brokerMedia.isBrokerDestination(destination)) {
            Message message = new Message(frame.getPayload()).headerAdd((Iterable<KeyValues<String>>)frame.getHeaderAll());
            this.brokerMedia.emitter.sendTo(destination, message);
        }
    }

    protected void toApp(StompSession session, String destination, Frame frame) throws Throwable {
        StompContext ctx = new StompContext(session, frame, destination, this.brokerMedia);
        Handler handler = Solon.app().router().matchMain((Context)ctx);
        if (handler != null) {
            Context.currentWith((Context)ctx, () -> {
                handler.handle((Context)ctx);
                if (!ctx.asyncStarted()) {
                    ctx.innerCommit();
                }
                return null;
            });
        }
    }
}

