/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.broker.impl;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.noear.solon.core.util.KeyValue;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.StompSession;
import org.noear.solon.net.stomp.broker.impl.StompBrokerMedia;
import org.noear.solon.net.stomp.broker.impl.StompSessionImpl;
import org.noear.solon.net.stomp.broker.impl.Subscription;
import org.noear.solon.net.stomp.listener.StompListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerMediaStompListener
implements StompListener {
    static final Logger log = LoggerFactory.getLogger(BrokerMediaStompListener.class);
    private final StompBrokerMedia brokerMedia;

    public BrokerMediaStompListener(StompBrokerMedia brokerMedia) {
        this.brokerMedia = brokerMedia;
    }

    @Override
    public void onOpen(StompSession session) {
        this.brokerMedia.sessionIdMap.put(session.id(), session);
        if (session.name() != null) {
            this.brokerMedia.sessionNameMap.computeIfAbsent(session.name(), k -> new CopyOnWriteArrayList()).add(session);
        }
    }

    @Override
    public void onClose(StompSession session) {
        List<StompSession> sessionList;
        this.brokerMedia.sessionIdMap.remove(session.id());
        if (session.name() != null && (sessionList = this.brokerMedia.sessionNameMap.get(session.name())) != null) {
            sessionList.remove(session);
            if (sessionList.size() == 0) {
                this.brokerMedia.sessionNameMap.remove(session.name());
            }
        }
        this.onUnsubscribe(session, null);
    }

    @Override
    public void onFrame(StompSession session, Frame frame) {
        switch (frame.getCommand()) {
            case "STOMP": 
            case "CONNECT": {
                this.onConnect(session, frame);
                break;
            }
            case "DISCONNECT": {
                this.onDisconnect(session, frame);
                break;
            }
            case "SUBSCRIBE": {
                this.onSubscribe(session, frame);
                break;
            }
            case "UNSUBSCRIBE": {
                this.onUnsubscribe(session, frame);
                break;
            }
            case "SEND": {
                this.onSend(session, frame);
                break;
            }
            case "ACK": 
            case "NACK": {
                this.onAck(session, frame);
                break;
            }
            default: {
                log.warn("Frame unknown, {}\r\n{}", (Object)session.id(), (Object)frame.getSource());
                session.send(Frame.newBuilder().command("UNKNOWN").payload(frame.getSource()).build());
            }
        }
    }

    @Override
    public void onError(StompSession socket, Throwable error) {
    }

    public void onConnect(StompSession session, Frame frame) {
        String heartBeat = frame.getHeader("heart-beat");
        Frame frame1 = Frame.newBuilder().command("CONNECTED").headerAdd(new KeyValue("heart-beat", (Object)(heartBeat == null ? "0,0" : heartBeat)), new KeyValue("server", (Object)"stomp"), new KeyValue("version", (Object)"1.2")).build();
        session.send(frame1);
    }

    public void onDisconnect(StompSession session, Frame frame) {
    }

    public void onSubscribe(StompSession session, Frame frame) {
        String subscriptionId = frame.getHeader("id");
        String destination = frame.getHeader("destination");
        if (destination == null || destination.length() == 0 || subscriptionId == null || subscriptionId.length() == 0) {
            Frame frame1 = Frame.newBuilder().command("ERROR").payload("Required 'destination' or 'id' header missed").build();
            session.send(frame1);
            return;
        }
        Subscription subscription = new Subscription(session.id(), destination, subscriptionId);
        ((StompSessionImpl)session).addSubscription(subscription);
        this.brokerMedia.subscriptions.add(subscription);
    }

    public void onUnsubscribe(StompSession socket, Frame frame) {
        String sessionId = socket.id();
        if (frame == null) {
            this.unSubscribeHandle(destinationInfo -> sessionId.equals(destinationInfo.getSessionId()));
        } else {
            String subscriptionId = frame.getHeader("id");
            String destination = frame.getHeader("destination");
            this.unSubscribeHandle(subscription -> sessionId.equals(subscription.getSessionId()) && (subscription.getDestination().equals(destination) || subscription.getId().equals(subscriptionId)));
        }
    }

    public void onSend(StompSession session, Frame frame) {
    }

    public void onAck(StompSession session, Frame frame) {
    }

    protected void unSubscribeHandle(Function<Subscription, Boolean> function) {
        Iterator<Subscription> iterator = this.brokerMedia.subscriptions.iterator();
        while (iterator.hasNext()) {
            if (!function.apply(iterator.next()).booleanValue()) continue;
            iterator.remove();
        }
    }
}

