/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.handle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.Message;
import org.noear.solon.net.stomp.StompEmitter;
import org.noear.solon.net.stomp.StompSession;
import org.noear.solon.net.stomp.broker.impl.StompBrokerMedia;
import org.noear.solon.server.handle.AsyncContextState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompContext
extends ContextEmpty {
    static final Logger log = LoggerFactory.getLogger(StompContext.class);
    private final StompSession session;
    private final Frame frame;
    private final String destination;
    private final StompBrokerMedia brokerMedia;
    private InputStream bodyAsStream;
    protected final AsyncContextState asyncState = new AsyncContextState();

    public StompContext(StompSession session, Frame frame, String destination, StompBrokerMedia brokerMedia) {
        this.session = session;
        this.frame = frame;
        this.destination = destination;
        this.brokerMedia = brokerMedia;
    }

    public Frame frame() {
        return this.frame;
    }

    public StompEmitter emitter() {
        return this.brokerMedia.emitter;
    }

    public Object request() {
        return this.session;
    }

    public String remoteIp() {
        try {
            return this.session.remoteAddress().getAddress().toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public int remotePort() {
        try {
            return this.session.remoteAddress().getPort();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isMultipart() {
        return false;
    }

    public String sessionId() {
        return this.session.id();
    }

    public String method() {
        return MethodType.MESSAGE.name;
    }

    public String path() {
        return this.destination;
    }

    public String contentType() {
        return this.frame.getHeader("content-type");
    }

    public InputStream bodyAsStream() throws IOException {
        if (this.bodyAsStream == null) {
            this.bodyAsStream = new ByteArrayInputStream(this.frame.getPayload().getBytes(StandardCharsets.UTF_8));
        }
        return this.bodyAsStream;
    }

    public String body(String charset) throws IOException {
        return this.frame.getPayload();
    }

    public MultiMap<String> headerMap() {
        if (this.headerMap == null) {
            this.headerMap = this.frame.getHeaderAll();
        }
        return this.headerMap;
    }

    public Object response() {
        return this.session;
    }

    public void contentType(String contentType) {
        this.headerSet("content-type", contentType);
    }

    public Object pull(Class<?> clz) {
        if (Frame.class.isAssignableFrom(clz)) {
            return this.frame;
        }
        if (StompSession.class.isAssignableFrom(clz)) {
            return this.session;
        }
        return null;
    }

    protected void innerCommit() throws Throwable {
        ByteArrayOutputStream baos;
        if ((this.getHandled() || this.status() >= 200) && (baos = (ByteArrayOutputStream)this.outputStream()).size() > 0) {
            String returnValue = new String(baos.toByteArray());
            this.commit(returnValue);
        }
    }

    private void commit(Object returnValue) throws Throwable {
        List toList;
        Message message = returnValue instanceof Message ? (Message)returnValue : (returnValue instanceof String ? new Message((String)returnValue) : new Message(this.renderAndReturn(returnValue)));
        if (this.headerOfResponseMap != null) {
            for (KeyValues kv : this.headerOfResponseMap) {
                String key = kv.getKey().toLowerCase();
                for (String val : kv.getValues()) {
                    message.headerAdd(key, val);
                }
            }
        }
        if (Utils.isEmpty((Collection)(toList = (List)this.attr("ATTR_TO")))) {
            if (this.brokerMedia.isBrokerDestination(this.path())) {
                this.sendTo("*", this.path(), message);
            } else {
                this.sendTo(".", this.path(), message);
            }
        } else {
            for (String to : toList) {
                int idx = to.indexOf(58);
                if (idx < 0) {
                    this.sendTo(to, this.path(), message);
                    continue;
                }
                this.sendTo(to.substring(0, idx), to.substring(idx + 1), message);
            }
        }
    }

    private void sendTo(String target, String destination, Message message) {
        if ("*".equals(target)) {
            this.emitter().sendTo(destination, message);
        } else if (".".equals(target)) {
            this.emitter().sendToSession(this.session, destination, message);
        } else {
            this.emitter().sendToUser(target, destination, message);
        }
    }

    public boolean asyncSupported() {
        return true;
    }

    public boolean asyncStarted() {
        return this.asyncState.isStarted;
    }

    public void asyncListener(ContextAsyncListener listener) {
        this.asyncState.addListener(listener);
    }

    public void asyncStart(long timeout, Runnable runnable) {
        if (!this.asyncState.isStarted) {
            this.asyncState.isStarted = true;
            this.asyncState.asyncDelay(timeout, (Context)this, this::innerCommit);
            if (runnable != null) {
                runnable.run();
            }
            this.asyncState.onStart((Context)this);
        }
    }

    public void asyncComplete() {
        if (this.asyncState.isStarted) {
            try {
                this.innerCommit();
            }
            catch (Throwable e) {
                log.warn("Async completion failed", e);
                this.asyncState.onError((Context)this, e);
            }
            finally {
                this.asyncState.onComplete((Context)this);
            }
        }
    }
}

