/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.broker.impl;

import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.core.util.KeyValues;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.Message;
import org.noear.solon.net.stomp.StompEmitter;
import org.noear.solon.net.stomp.StompSession;
import org.noear.solon.net.stomp.broker.impl.StompBrokerMedia;
import org.noear.solon.net.stomp.broker.impl.StompSessionImpl;
import org.noear.solon.net.stomp.broker.impl.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompBrokerEmitter
implements StompEmitter {
    static final Logger log = LoggerFactory.getLogger(StompBrokerEmitter.class);
    private final StompBrokerMedia brokerMedia;

    protected StompBrokerEmitter(StompBrokerMedia brokerMedia) {
        this.brokerMedia = brokerMedia;
    }

    private void sendToSessionDo(StompSession session, Subscription subscription, String destination, Message message) {
        if (subscription != null) {
            Frame replyMessage = Frame.newBuilder().command("MESSAGE").payload(message.getPayload()).headerAdd((Iterable<KeyValues<String>>)message.getHeaderAll()).headerSet("destination", destination).headerSet("subscription", subscription.getId()).headerSet("message-id", Utils.guid()).build();
            session.send(replyMessage);
        } else {
            log.warn("No subscription found: '{}'", (Object)destination);
        }
    }

    @Override
    public void sendToSession(StompSession session, String destination, Message message) {
        Subscription subscription = ((StompSessionImpl)session).getSubscription(destination);
        this.sendToSessionDo(session, subscription, destination, message);
    }

    @Override
    public void sendToUser(String user, String destination, Message message) {
        List<StompSession> sessions = this.brokerMedia.sessionNameMap.get(user);
        if (sessions == null) {
            log.warn("No user found: '{}'", (Object)user);
        } else {
            for (StompSession s1 : sessions) {
                this.sendToSession(s1, destination, message);
            }
        }
    }

    @Override
    public void sendTo(String destination, Message message) {
        assert (message != null);
        if (Utils.isEmpty((String)destination)) {
            return;
        }
        this.brokerMedia.subscriptions.parallelStream().filter(subscription -> subscription.matches(destination)).forEach(subscription -> {
            StompSession session = this.brokerMedia.sessionIdMap.get(subscription.getSessionId());
            if (session != null) {
                this.sendToSessionDo(session, (Subscription)subscription, destination, message);
            }
        });
    }
}

