/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.handle;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.broker.StompBroker;
import org.noear.solon.net.stomp.handle.StompContext;
import org.noear.solon.net.stomp.listener.SimpleStompListener;
import org.noear.solon.net.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToHandlerStompListener
extends SimpleStompListener {
    private static final Logger log = LoggerFactory.getLogger(ToHandlerStompListener.class);
    private final StompBroker broker;

    public ToHandlerStompListener(StompBroker broker) {
        this.broker = broker;
    }

    @Override
    public void onFrame(WebSocket socket, Frame frame) {
        if ("SEND".equals(frame.getCommand())) {
            String destination = frame.getHeader("destination");
            if (Utils.isEmpty((String)destination)) {
                log.warn("This stomp message is missing route, source={}", (Object)frame.getSource());
            } else {
                try {
                    StompContext ctx = new StompContext(socket, frame, destination, this.broker.getServerEmitter());
                    Solon.app().tryHandle((Context)ctx);
                    if (ctx.getHandled() || ctx.status() != 404) {
                        ctx.commit();
                    }
                }
                catch (Throwable e) {
                    log.warn(e.getMessage(), e);
                }
            }
        }
    }
}

