/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.handle;

import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.StompEmitter;
import org.noear.solon.net.stomp.handle.StompContext;
import org.noear.solon.net.stomp.listener.SimpleStompListener;
import org.noear.solon.net.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToHandlerStompListener
extends SimpleStompListener {
    private static final Logger log = LoggerFactory.getLogger(ToHandlerStompListener.class);
    private final StompEmitter sender;

    public ToHandlerStompListener(StompEmitter sender) {
        this.sender = sender;
    }

    @Override
    public void onSend(WebSocket socket, Frame frame) {
        String destination = frame.getHeader("destination");
        if (Utils.isNotEmpty((String)destination)) {
            StompContext ctx = new StompContext(socket, frame, destination, this.sender);
            this.handleDo((Context)ctx);
        }
    }

    protected void handleDo(Context ctx) {
        try {
            Handler handler = Solon.app().router().matchMain(ctx);
            if (handler != null) {
                handler.handle(ctx);
            }
        }
        catch (Throwable ex) {
            log.warn(ex.getMessage(), ex);
        }
    }
}

