/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.stomp.handle;

import java.io.IOException;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.util.KeyValue;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.net.stomp.Frame;
import org.noear.solon.net.stomp.StompEmitter;
import org.noear.solon.net.stomp.handle.StompReturnHandler;
import org.noear.solon.net.websocket.WebSocket;

public class StompContext
extends ContextEmpty {
    private WebSocket session;
    private Frame frame;
    private String destination;
    private StompEmitter emitter;

    public StompContext(WebSocket session, Frame frame, String destination, StompEmitter emitter) {
        this.session = session;
        this.frame = frame;
        this.destination = destination;
        this.emitter = emitter;
        this.attrSet("ATTR_RETURN_HANDLER", StompReturnHandler.getInstance());
    }

    public Frame frame() {
        return this.frame;
    }

    public StompEmitter emitter() {
        return this.emitter;
    }

    public Object request() {
        return this.session;
    }

    public String sessionId() {
        return this.session.id();
    }

    public String method() {
        return MethodType.MESSAGE.name;
    }

    public String path() {
        return this.destination;
    }

    public String contentType() {
        return this.frame.getHeader("content-type");
    }

    public String body(String charset) throws IOException {
        return this.frame.getPayload();
    }

    public MultiMap<String> headerMap() {
        if (this.headerMap == null) {
            this.headerMap = new MultiMap();
            for (KeyValue<String> kv : this.frame.getHeaderAll()) {
                this.headerMap.add(kv.getKey(), kv.getValue());
            }
        }
        return this.headerMap;
    }

    public Object pull(Class<?> clz) {
        if (Frame.class.isAssignableFrom(clz)) {
            return this.frame;
        }
        if (WebSocket.class.isAssignableFrom(clz)) {
            return this.session;
        }
        return null;
    }
}

